/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.registry.RegistryHelper;
import sirttas.elementalcraft.spell.AoeSpell;
import sirttas.elementalcraft.spell.EffectSpell;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.air.DashSpell;
import sirttas.elementalcraft.spell.air.EnderStrikeSpell;
import sirttas.elementalcraft.spell.air.FeatherSpikesSpell;
import sirttas.elementalcraft.spell.air.ItemPullSpell;
import sirttas.elementalcraft.spell.air.TranslocationSpell;
import sirttas.elementalcraft.spell.airshield.AirShieldSpell;
import sirttas.elementalcraft.spell.earth.GavelFallSpell;
import sirttas.elementalcraft.spell.earth.SilkVeinSpell;
import sirttas.elementalcraft.spell.earth.StoneWallSpell;
import sirttas.elementalcraft.spell.earth.TreeFallSpell;
import sirttas.elementalcraft.spell.fire.FireBallSpell;
import sirttas.elementalcraft.spell.fire.InfernoSpell;
import sirttas.elementalcraft.spell.flamecleave.FlameCleaveSpell;
import sirttas.elementalcraft.spell.repair.RepairSpell;
import sirttas.elementalcraft.spell.water.AnimalGrowthSpell;
import sirttas.elementalcraft.spell.water.PurificationSpell;
import sirttas.elementalcraft.spell.water.RipeningSpell;

public class Spells {
    private static final DeferredRegister<Spell> DEFERRED_REGISTER = DeferredRegister.create((ResourceLocation)ElementalCraft.createRL("spell"), (String)"elementalcraft");
    public static final Supplier<IForgeRegistry<Spell>> REGISTRY = DEFERRED_REGISTER.makeRegistry(RegistryHelper.builder(b -> b.setDefaultKey(ElementalCraft.createRL("none"))));
    public static final RegistryObject<Spell> NONE = Spells.register("none", Spell::new);
    public static final RegistryObject<GavelFallSpell> GRAVEL_FALL = Spells.register("gravelfall", GavelFallSpell::new);
    public static final RegistryObject<StoneWallSpell> STONE_WALL = Spells.register("stonewall", StoneWallSpell::new);
    public static final RegistryObject<FireBallSpell> FIRE_BALL = Spells.register("fireball", FireBallSpell::new);
    public static final RegistryObject<ItemPullSpell> ITEM_PULL = Spells.register("item_pull", ItemPullSpell::new);
    public static final RegistryObject<EnderStrikeSpell> ENDER_STRIKE = Spells.register("ender_strike", EnderStrikeSpell::new);
    public static final RegistryObject<FlameCleaveSpell> FLAME_CLEAVE = Spells.register("flame_cleave", FlameCleaveSpell::new);
    public static final RegistryObject<TranslocationSpell> TRANSLOCATION = Spells.register("translocation", TranslocationSpell::new);
    public static final RegistryObject<DashSpell> DASH = Spells.register("dash", DashSpell::new);
    public static final RegistryObject<SilkVeinSpell> SILK_VEIN = Spells.register("silk_vein", SilkVeinSpell::new);
    public static final RegistryObject<AnimalGrowthSpell> ANIMAL_GROWTH = Spells.register("animal_growth", AnimalGrowthSpell::new);
    public static final RegistryObject<RipeningSpell> RIPENING = Spells.register("ripening", RipeningSpell::new);
    public static final RegistryObject<PurificationSpell> PURIFICATION = Spells.register("purification", PurificationSpell::new);
    public static final RegistryObject<FeatherSpikesSpell> FEATHER_SPIKES = Spells.register("feather_spikes", k -> new FeatherSpikesSpell((ResourceKey<Spell>)k, 3));
    public static final RegistryObject<TreeFallSpell> TREE_FALL = Spells.register("tree_fall", TreeFallSpell::new);
    public static final RegistryObject<InfernoSpell> INFERNO = Spells.register("inferno", InfernoSpell::new);
    public static final RegistryObject<EffectSpell> HEAL = Spells.register("heal", k -> new EffectSpell((ResourceKey<Spell>)k, new MobEffectInstance(MobEffects.f_19601_, 1, 1)));
    public static final RegistryObject<EffectSpell> SPEED = Spells.register("speed", k -> new EffectSpell((ResourceKey<Spell>)k, new MobEffectInstance(MobEffects.f_19596_, 2400, 1), new MobEffectInstance(MobEffects.f_19598_, 2400)));
    public static final RegistryObject<AoeSpell> SHOCKWAVE = Spells.register("shockwave", AoeSpell::new);
    public static final RegistryObject<AirShieldSpell> AIR_SHIELD = Spells.register("air_shield", AirShieldSpell::new);
    public static final RegistryObject<RepairSpell> REPAIR = Spells.register("repair", RepairSpell::new);

    private Spells() {
    }

    private static <T extends Spell> RegistryObject<T> register(String name, Function<ResourceKey<Spell>, ? extends T> builder) {
        return DEFERRED_REGISTER.register(name, () -> (Spell)builder.apply(ResourceKey.m_135785_((ResourceKey)REGISTRY.get().getRegistryKey(), (ResourceLocation)ElementalCraft.createRL(name))));
    }

    public static void register(IEventBus modBus) {
        DEFERRED_REGISTER.register(modBus);
    }
}

