/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.item.ECItem;
import sirttas.elementalcraft.spell.Spell;

public class EffectSpell
extends Spell {
    private final List<MobEffectInstance> effects;

    public EffectSpell(ResourceKey<Spell> key, MobEffectInstance ... effects) {
        super(key);
        this.effects = ImmutableList.copyOf((Object[])effects);
    }

    private InteractionResult applyEffect(Entity target) {
        if (target instanceof LivingEntity) {
            this.effects.forEach(e -> ((LivingEntity)target).m_7292_(new MobEffectInstance(e)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nonnull
    public InteractionResult castOnEntity(@Nonnull Entity caster, @Nonnull Entity target) {
        return this.applyEffect(target);
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        return this.applyEffect(caster);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addInformation(List<Component> tooltip) {
        HashMultimap multiMap = HashMultimap.create();
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance effectInstance : this.effects) {
                MutableComponent mutableComponent = Component.m_237115_((String)effectInstance.m_19576_());
                MobEffect effect = effectInstance.m_19544_();
                Map map = effect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributeModifier1 = new AttributeModifier(attributemodifier.m_22214_(), effect.m_7048_(effectInstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        multiMap.put((Object)((Attribute)entry.getKey()), (Object)attributeModifier1);
                    }
                }
                if (effectInstance.m_19564_() > 0) {
                    mutableComponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutableComponent, Component.m_237115_((String)("potion.potency." + effectInstance.m_19564_()))});
                }
                if (effectInstance.m_19557_() > 20) {
                    mutableComponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutableComponent, MobEffectUtil.m_19581_((MobEffectInstance)effectInstance, (float)1.0f)});
                }
                tooltip.add((Component)mutableComponent.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
        ECItem.addAttributeMultiMapToTooltip(tooltip, (Multimap<Attribute, AttributeModifier>)multiMap, (Component)Component.m_237115_((String)"tooltip.elementalcraft.spell_effect_on_use").m_130940_(ChatFormatting.DARK_PURPLE));
    }

    public final List<MobEffectInstance> getEffects() {
        return this.effects;
    }
}

