/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import sirttas.elementalcraft.jewel.Jewel;
import sirttas.elementalcraft.jewel.Jewels;
import sirttas.elementalcraft.jewel.attribute.AttributeJewel;
import sirttas.elementalcraft.jewel.handler.IJewelHandler;
import sirttas.elementalcraft.nbt.NBTHelper;

public class JewelHelper {
    private JewelHelper() {
    }

    public static Jewel getJewel(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        CompoundTag nbt = NBTHelper.getECTag(stack);
        if (nbt != null && nbt.m_128425_("jewel", 8)) {
            return (Jewel)Jewels.REGISTRY.get().getValue(new ResourceLocation(nbt.m_128461_("jewel")));
        }
        return null;
    }

    public static void setJewel(ItemStack stack, Jewel jewel) {
        if (stack.m_41619_()) {
            return;
        }
        CompoundTag nbt = NBTHelper.getOrCreateECTag(stack);
        nbt.m_128359_("jewel", jewel.getKey().toString());
    }

    public static List<Jewel> getAllJewels(Entity entity) {
        ArrayList<Jewel> list = new ArrayList<Jewel>();
        for (ItemStack item : entity.m_20158_()) {
            Jewel jewel = JewelHelper.getJewel(item);
            if (jewel == null) continue;
            list.add(jewel);
        }
        return list;
    }

    public static List<Jewel> getActiveJewels(Entity entity) {
        return entity.getCapability(IJewelHandler.CAPABILITY).map(IJewelHandler::getActiveJewels).orElse(Collections.emptyList());
    }

    public static boolean hasJewel(Entity entity, Jewel jewel) {
        return JewelHelper.getActiveJewels(entity).contains(jewel);
    }

    public static Multimap<Attribute, AttributeModifier> getJewelsAttribute(Entity entity) {
        ArrayListMultimap map = ArrayListMultimap.create();
        for (Jewel jewel : JewelHelper.getActiveJewels(entity)) {
            if (!jewel.isTicking() || !(jewel instanceof AttributeJewel)) continue;
            AttributeJewel attributeJewel = (AttributeJewel)jewel;
            map.putAll(attributeJewel.getAttributes());
        }
        return map;
    }
}

