/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.holder;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.ElementStorageHelper;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.StaticElementStorage;
import sirttas.elementalcraft.api.source.ISourceInteractable;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.holder.AbstractElementHolderItem;

public class ElementHolderItem
extends AbstractElementHolderItem
implements ISourceInteractable,
IElementTypeProvider {
    public static final String NAME = "element_holder";
    public static final String NAME_FIRE = "element_holder_fire";
    public static final String NAME_WATER = "element_holder_water";
    public static final String NAME_EARTH = "element_holder_earth";
    public static final String NAME_AIR = "element_holder_air";
    private final ElementType elementType;

    public ElementHolderItem(ElementType elementType) {
        super(() -> ((ForgeConfigSpec.IntValue)ECConfig.COMMON.elementHolderCapacity).get(), () -> ((ForgeConfigSpec.IntValue)ECConfig.COMMON.elementHolderTransferAmount).get());
        this.elementType = elementType;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    protected ElementType getElementType(IElementStorage target, BlockState blockstate) {
        return this.elementType;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        ElementStorage storage = new ElementStorage(stack);
        if (nbt != null && nbt.m_128441_("Parent")) {
            storage.deserializeNBT(nbt.m_128469_("Parent"));
        }
        return ElementStorageHelper.createProvider(storage);
    }

    @Override
    public ISingleElementStorage getElementStorage(ItemStack stack) {
        return (ISingleElementStorage)ElementStorageHelper.get((ICapabilityProvider)stack).orElse((Object)new StaticElementStorage(this.elementType, 0));
    }

    @Override
    protected boolean isValidSource(BlockState state) {
        return super.isValidSource(state) && ElementType.getElementType(state) == this.elementType;
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            ItemStack full = new ItemStack((ItemLike)this);
            ISingleElementStorage storage = this.getElementStorage(full);
            storage.insertElement(this.elementCapacity.getAsInt(), false);
            items.add((Object)new ItemStack((ItemLike)this));
            items.add((Object)full);
        }
    }

    public int m_142159_(@Nonnull ItemStack stack) {
        return this.elementType.getColor();
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return Math.round((float)this.getElementStorage(stack).getElementAmount() * 13.0f / (float)this.elementCapacity.getAsInt());
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean m_41465_() {
        return true;
    }

    private class ElementStorage
    extends StaticElementStorage {
        private final ItemStack stack;

        public ElementStorage(ItemStack stack) {
            super(ElementHolderItem.this.elementType, ElementHolderItem.this.elementCapacity.getAsInt());
            this.stack = stack;
        }

        @Override
        public boolean usableInInventory() {
            return true;
        }

        @Override
        public int getElementAmount() {
            this.refresh();
            return super.getElementAmount();
        }

        @Override
        public int insertElement(int count, ElementType type, boolean simulate) {
            this.refresh();
            int value = super.insertElement(count, type, simulate);
            this.updateAmount();
            return value;
        }

        @Override
        public int extractElement(int count, ElementType type, boolean simulate) {
            this.refresh();
            int value = super.extractElement(count, type, simulate);
            this.updateAmount();
            return value;
        }

        private void refresh() {
            CompoundTag tag = this.stack.m_41783_();
            if (tag != null && tag.m_128441_("element_amount")) {
                this.elementAmount = tag.m_128451_("element_amount");
            }
        }

        private void updateAmount() {
            this.stack.m_41784_().m_128405_("element_amount", this.elementAmount);
        }
    }
}

