/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category.shrine;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.shrine.budding.BuddingShrineBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.AbstractHorizontalShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.SpringalineShrineUpgradeBlock;
import sirttas.elementalcraft.interaction.jei.ECJEIRecipeTypes;
import sirttas.elementalcraft.interaction.jei.category.shrine.AbstractShrineRecipeCategory;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class BuddingShrineRecipeCategory
extends AbstractShrineRecipeCategory<BuddingShrineBlock.CrystalType> {
    private final ITickTimer timer;
    private final BlockState springalineShrineUpgrade;

    public BuddingShrineRecipeCategory(IGuiHelper guiHelper) {
        super("elementalcraft.jei.buddingshrine", BuddingShrineRecipeCategory.createDrawableStack(guiHelper, new ItemStack((ItemLike)ECBlocks.BUDDING_SHRINE.get())), (IDrawable)guiHelper.createBlankDrawable(110, 66));
        this.timer = guiHelper.createTickTimer(100, 4, false);
        this.springalineShrineUpgrade = (BlockState)((SpringalineShrineUpgradeBlock)((Object)ECBlocks.SPRINGALINE_SHRINE_UPGRADE.get())).m_49966_().m_61124_((Property)AbstractHorizontalShrineUpgradeBlock.FACING, (Comparable)Direction.SOUTH);
        this.setOverlay((IDrawable)guiHelper.createDrawable(ElementalCraft.createRL("textures/gui/overlay/extraction.png"), 0, 0, 24, 9), 61, 44);
    }

    @Nonnull
    public RecipeType<BuddingShrineBlock.CrystalType> getRecipeType() {
        return ECJEIRecipeTypes.BUDDING_SHRINE;
    }

    private BlockState getGrowthCrystal(BuddingShrineBlock.CrystalType type) {
        int t = this.timer.getValue();
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case BuddingShrineBlock.CrystalType.AMETHYST -> {
                switch (t) {
                    case 1: {
                        yield Blocks.f_152495_.m_49966_();
                    }
                    case 2: {
                        yield Blocks.f_152494_.m_49966_();
                    }
                    case 3: {
                        yield Blocks.f_152493_.m_49966_();
                    }
                    case 4: {
                        yield Blocks.f_152492_.m_49966_();
                    }
                }
                yield Blocks.f_50016_.m_49966_();
            }
            case BuddingShrineBlock.CrystalType.SPRINGALINE -> {
                switch (t) {
                    case 1: {
                        yield ((AmethystClusterBlock)ECBlocks.SMALL_SPRINGALINE_BUD.get()).m_49966_();
                    }
                    case 2: {
                        yield ((AmethystClusterBlock)ECBlocks.MEDIUM_SPRINGALINE_BUD.get()).m_49966_();
                    }
                    case 3: {
                        yield ((AmethystClusterBlock)ECBlocks.LARGE_SPRINGALINE_BUD.get()).m_49966_();
                    }
                    case 4: {
                        yield ((AmethystClusterBlock)ECBlocks.SPRINGALINE_CLUSTER.get()).m_49966_();
                    }
                }
                yield Blocks.f_50016_.m_49966_();
            }
        };
    }

    @Override
    public void draw(@Nonnull BuddingShrineBlock.CrystalType crystalType, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull PoseStack poseStack, double mouseX, double mouseY) {
        BuddingShrineRecipeCategory.render3D(poseStack, (p, b) -> {
            p.m_85837_(0.0, 0.5, 0.0);
            BuddingShrineRecipeCategory.setupPose(p);
            ECRendererHelper.renderBlock((BlockState)((BuddingShrineBlock)ECBlocks.BUDDING_SHRINE.get()).m_49966_().m_61124_(BuddingShrineBlock.CRYSTAL_TYPE, (Comparable)((Object)crystalType)), p, b);
            if (crystalType == BuddingShrineBlock.CrystalType.SPRINGALINE) {
                p.m_85836_();
                p.m_85837_(0.0, 0.0, -1.0);
                ECRendererHelper.renderBlock(this.springalineShrineUpgrade, p, b);
                p.m_85849_();
            }
            p.m_85837_(0.0, 1.0, 0.0);
            ECRendererHelper.renderBlock(this.getGrowthCrystal(crystalType), p, b);
        });
        super.draw(crystalType, recipeSlotsView, poseStack, mouseX, mouseY);
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull BuddingShrineBlock.CrystalType crystalType, @Nonnull IFocusGroup focuses) {
        IRecipeSlotBuilder iRecipeSlotBuilder = builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 40);
        iRecipeSlotBuilder.addItemStack(new ItemStack((ItemLike)(switch (crystalType) {
            default -> throw new IncompatibleClassChangeError();
            case BuddingShrineBlock.CrystalType.AMETHYST -> Blocks.f_152492_;
            case BuddingShrineBlock.CrystalType.SPRINGALINE -> (AmethystClusterBlock)ECBlocks.SPRINGALINE_CLUSTER.get();
        })));
    }
}

