/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe.upgrade.pump;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import sirttas.elementalcraft.api.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPath;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPathNode;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.pipe.ConnectionType;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.ElementPipeShapes;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeType;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeTypes;
import sirttas.elementalcraft.block.shape.ShapeHelper;
import sirttas.elementalcraft.config.ECConfig;

public class ElementPumpPipeUpgrade
extends PipeUpgrade {
    public static final String NAME = "element_pump";
    private static final Map<Direction, VoxelShape> SHAPES = ShapeHelper.directionShapes(Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.1, (double)9.0, (double)6.1, (double)7.1, (double)15.0, (double)7.1), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.1, (double)9.0, (double)8.9, (double)7.1, (double)15.0, (double)9.9), Block.m_49796_((double)8.9, (double)9.0, (double)6.1, (double)9.9, (double)15.0, (double)7.1), Block.m_49796_((double)8.9, (double)9.0, (double)8.9, (double)9.9, (double)15.0, (double)9.9), ElementPipeShapes.SECTION_SHAPES.get(Direction.UP), ElementPipeShapes.EXTRACTION_SHAPES.get(Direction.UP)}));
    private final RuneHandler runeHandler;

    public ElementPumpPipeUpgrade(ElementPipeBlockEntity pipe, Direction direction) {
        super((PipeUpgradeType)PipeUpgradeTypes.ELEMENT_PUMP.get(), pipe, direction);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.elementPumpMaxRunes.get(), pipe::m_6596_);
    }

    @Override
    public IElementTransferPath alterPath(@Nonnull IElementTransferPath path) {
        return new Path(path);
    }

    @Override
    public VoxelShape getShape() {
        return SHAPES.get(this.getDirection());
    }

    @Override
    public boolean replaceSection() {
        return true;
    }

    @Override
    public boolean canPlace(ConnectionType connectionType) {
        return super.canPlace(connectionType) && connectionType == ConnectionType.EXTRACT && this.getPipe().m_58900_().m_60713_((Block)ECBlocks.PIPE_IMPROVED.get());
    }

    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Override
    public void load(@Nonnull CompoundTag compound) {
        super.load(compound);
        if (compound.m_128441_("rune_handler")) {
            IRuneHandler.readNBT(this.getRuneHandler(), compound.m_128437_("rune_handler", 8));
        }
    }

    @Override
    public void saveAdditional(@Nonnull CompoundTag compound) {
        super.saveAdditional(compound);
        compound.m_128365_("rune_handler", (Tag)IRuneHandler.writeNBT(this.getRuneHandler()));
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (cap == ElementalCraftCapabilities.RUNE_HANDLE) {
            return LazyOptional.of(() -> this.runeHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    private class Path
    implements IElementTransferPath {
        private final IElementTransferPath parent;
        private final List<IElementTransferPathNode> nodes;

        private Path(IElementTransferPath parent) {
            this.parent = parent;
            this.nodes = parent.getNodes();
        }

        @Override
        public boolean isValid() {
            return this.parent.isValid();
        }

        private int getRemainingTransferAmount() {
            return this.nodes.stream().map(IElementTransferPathNode::getTransferer).filter(Objects::nonNull).mapToInt(IElementTransferer::getRemainingTransferAmount).min().orElse(0);
        }

        @Override
        public void transfer() {
            if (!this.isValid()) {
                return;
            }
            ElementType type = this.parent.getElementType();
            float multiplier = ElementPumpPipeUpgrade.this.runeHandler.getTransferSpeed(((Double)ECConfig.COMMON.elementPumpMultiplier.get()).floatValue());
            float waste = Math.max(0.0f, ((Double)ECConfig.COMMON.elementPumpWaste.get()).floatValue() / ElementPumpPipeUpgrade.this.runeHandler.getElementPreservation());
            IElementStorage source = this.nodes.get(0).getStorage();
            IElementStorage target = this.nodes.get(this.nodes.size() - 1).getStorage();
            if (source == null || target == null) {
                return;
            }
            IElementTransferPath.transfer(type, Math.round((float)source.transferTo(target, type, (float)this.getRemainingTransferAmount() * multiplier, 1.0f - waste) / multiplier), this.nodes);
        }

        @Override
        public List<IElementTransferPathNode> getNodes() {
            return List.copyOf(this.nodes);
        }

        @Override
        public ElementType getElementType() {
            return this.parent.getElementType();
        }
    }
}

