/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.recipe.architectscutter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockManager;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.recipe.ModRecipeSerializers;
import com.ldtteam.domumornamentum.recipe.ModRecipeTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ArchitectsCutterRecipe
implements Recipe<Container> {
    private final ResourceLocation recipeId;
    private final ResourceLocation blockName;
    private final int count;
    private final CompoundTag additionalTag;

    public ArchitectsCutterRecipe(ResourceLocation blockName, int count) {
        this.recipeId = blockName;
        this.blockName = blockName;
        this.count = count;
        this.additionalTag = new CompoundTag();
    }

    public ArchitectsCutterRecipe(ResourceLocation recipeId, ResourceLocation blockName, int count, CompoundTag additionalTag) {
        this.recipeId = recipeId;
        this.blockName = blockName;
        this.count = count;
        this.additionalTag = additionalTag;
    }

    public ResourceLocation getBlockName() {
        return this.blockName;
    }

    public boolean m_5818_(@NotNull Container inv, @NotNull Level worldIn) {
        if (!ForgeRegistries.BLOCKS.containsKey(this.getBlockName())) {
            return false;
        }
        Block generatedBlock = (Block)ForgeRegistries.BLOCKS.getValue(this.getBlockName());
        if (!(generatedBlock instanceof IMateriallyTexturedBlock)) {
            return false;
        }
        IMateriallyTexturedBlock materiallyTexturedBlock = (IMateriallyTexturedBlock)generatedBlock;
        ArrayList components = Lists.newArrayList(materiallyTexturedBlock.getComponents());
        for (int componentsIndex = 0; componentsIndex < components.size(); ++componentsIndex) {
            IMateriallyTexturedBlockComponent component = (IMateriallyTexturedBlockComponent)components.get(componentsIndex);
            ItemStack itemStackInSlot = inv.m_8020_(componentsIndex);
            Item item = itemStackInSlot.m_41720_();
            if (!(item instanceof BlockItem)) {
                return false;
            }
            BlockItem blockItem = (BlockItem)item;
            Block blockInSlot = blockItem.m_40614_();
            if (blockInSlot.m_49966_().m_204336_(component.getValidSkins())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container inv) {
        if (!ForgeRegistries.BLOCKS.containsKey(this.getBlockName())) {
            return ItemStack.f_41583_;
        }
        Block generatedBlock = (Block)ForgeRegistries.BLOCKS.getValue(this.getBlockName());
        if (!(generatedBlock instanceof IMateriallyTexturedBlock)) {
            return ItemStack.f_41583_;
        }
        IMateriallyTexturedBlock materiallyTexturedBlock = (IMateriallyTexturedBlock)generatedBlock;
        ArrayList components = Lists.newArrayList(materiallyTexturedBlock.getComponents());
        HashMap textureData = Maps.newHashMap();
        for (int componentsIndex = 0; componentsIndex < components.size(); ++componentsIndex) {
            IMateriallyTexturedBlockComponent component = (IMateriallyTexturedBlockComponent)components.get(componentsIndex);
            ItemStack itemStackInSlot = inv.m_8020_(componentsIndex);
            if (itemStackInSlot.m_41619_() && component.isOptional()) continue;
            Item item = itemStackInSlot.m_41720_();
            if (!(item instanceof BlockItem)) {
                return ItemStack.f_41583_;
            }
            BlockItem blockItem = (BlockItem)item;
            Block blockInSlot = blockItem.m_40614_();
            if (!blockInSlot.m_49966_().m_204336_(component.getValidSkins())) {
                return ItemStack.f_41583_;
            }
            textureData.put(component.getId(), blockInSlot);
        }
        MaterialTextureData materialTextureData = new MaterialTextureData(textureData);
        CompoundTag textureNbt = materialTextureData.serializeNBT();
        ItemStack result = new ItemStack((ItemLike)generatedBlock);
        result.m_41784_().m_128365_("textureData", (Tag)textureNbt);
        result.m_41764_(Math.max(components.size(), this.count));
        this.additionalTag.m_128431_().forEach(key -> result.m_41784_().m_128365_(key, Objects.requireNonNull(this.additionalTag.m_128423_(key)).m_6426_()));
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width * height <= IMateriallyTexturedBlockManager.getInstance().getMaxTexturableComponentCount();
    }

    @NotNull
    public ItemStack m_8043_() {
        if (!ForgeRegistries.BLOCKS.containsKey(this.getBlockName())) {
            return ItemStack.f_41583_;
        }
        Block generatedBlock = (Block)ForgeRegistries.BLOCKS.getValue(this.getBlockName());
        if (!(generatedBlock instanceof IMateriallyTexturedBlock)) {
            return ItemStack.f_41583_;
        }
        ItemStack result = new ItemStack((ItemLike)generatedBlock);
        this.additionalTag.m_128431_().forEach(key -> result.m_41784_().m_128365_(key, Objects.requireNonNull(this.additionalTag.m_128423_(key)).m_6426_()));
        return result;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.ARCHITECTS_CUTTER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.ARCHITECTS_CUTTER.get();
    }

    @NotNull
    public CompoundTag getAdditionalTag() {
        return this.additionalTag;
    }

    public int getCount() {
        return this.count;
    }
}

