/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.pillar;

import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.models.block.BlockModelJson;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.PillarBlock;
import com.ldtteam.domumornamentum.block.types.PillarShapeType;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class PillarBlockModelProvider
implements DataProvider {
    private final DataGenerator generator;

    public PillarBlockModelProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        for (PillarBlock type : ModBlocks.getInstance().getPillars()) {
            for (PillarShapeType shapeType : PillarShapeType.values()) {
                BlockModelJson modelJson = new BlockModelJson();
                modelJson.setLoader("domum_ornamentum:materially_textured");
                modelJson.setParent(new ResourceLocation("domum_ornamentum", "block/pillars/" + type.getRegistryName().m_135815_() + "_" + shapeType.name().toLowerCase(Locale.ROOT) + "_spec").toString());
                String name = type.getRegistryName().m_135815_() + "/" + shapeType.name().toLowerCase(Locale.ROOT) + ".json";
                Path saveFile = this.generator.m_123916_().resolve("assets/domum_ornamentum/models/block/pillars/").resolve(name);
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)modelJson), (Path)saveFile);
            }
        }
    }

    @NotNull
    public String m_6055_() {
        return "Pillar Block Model Provider";
    }
}

