/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.armor;

import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class BacktankUtil {
    public static ItemStack get(LivingEntity entity) {
        for (ItemStack itemStack : entity.m_6168_()) {
            if (!AllTags.AllItemTags.PRESSURIZED_AIR_SOURCES.matches(itemStack)) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean hasAirRemaining(ItemStack backtank) {
        return BacktankUtil.getAir(backtank) > 0.0f;
    }

    public static float getAir(ItemStack backtank) {
        CompoundTag tag = backtank.m_41784_();
        return Math.min(tag.m_128457_("Air"), (float)BacktankUtil.maxAir(backtank));
    }

    public static void consumeAir(LivingEntity entity, ItemStack backtank, float i) {
        CompoundTag tag = backtank.m_41784_();
        int maxAir = BacktankUtil.maxAir(backtank);
        float air = BacktankUtil.getAir(backtank);
        float newAir = air - i;
        tag.m_128350_("Air", Math.min(newAir, (float)maxAir));
        backtank.m_41751_(tag);
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        BacktankUtil.sendWarning(player, air, newAir, (float)maxAir / 10.0f);
        BacktankUtil.sendWarning(player, air, newAir, 1.0f);
    }

    private static void sendWarning(ServerPlayer player, float air, float newAir, float threshold) {
        if (newAir > threshold) {
            return;
        }
        if (air <= threshold) {
            return;
        }
        boolean depleted = threshold == 1.0f;
        MutableComponent component = Lang.translateDirect(depleted ? "backtank.depleted" : "backtank.low", new Object[0]);
        AllSoundEvents.DENY.play(player.f_19853_, null, (Vec3i)player.m_20183_(), 1.0f, 1.25f);
        AllSoundEvents.STEAM.play(player.f_19853_, null, (Vec3i)player.m_20183_(), 0.5f, 0.5f);
        player.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(10, 40, 10));
        player.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Components.literal("\u26a0 ").m_130940_(depleted ? ChatFormatting.RED : ChatFormatting.GOLD).m_7220_((Component)component.m_130940_(ChatFormatting.GRAY))));
        player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket(Components.immutableEmpty()));
    }

    public static int maxAir(ItemStack backtank) {
        return BacktankUtil.maxAir(backtank.getEnchantmentLevel((Enchantment)AllEnchantments.CAPACITY.get()));
    }

    public static int maxAir(int enchantLevel) {
        return (Integer)AllConfigs.server().equipment.airInBacktank.get() + (Integer)AllConfigs.server().equipment.enchantedBacktankCapacity.get() * enchantLevel;
    }

    public static int maxAirWithoutEnchants() {
        return (Integer)AllConfigs.server().equipment.airInBacktank.get();
    }

    public static boolean canAbsorbDamage(LivingEntity entity, int usesPerTank) {
        if (usesPerTank == 0) {
            return true;
        }
        if (entity instanceof Player && ((Player)entity).m_7500_()) {
            return true;
        }
        ItemStack backtank = BacktankUtil.get(entity);
        if (backtank.m_41619_()) {
            return false;
        }
        if (!BacktankUtil.hasAirRemaining(backtank)) {
            return false;
        }
        float cost = (float)BacktankUtil.maxAirWithoutEnchants() / (float)usesPerTank;
        BacktankUtil.consumeAir(entity, backtank, cost);
        return true;
    }

    public static boolean isBarVisible(ItemStack stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return false;
        }
        Player player = (Player)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91074_);
        if (player == null) {
            return false;
        }
        ItemStack backtank = BacktankUtil.get((LivingEntity)player);
        if (backtank.m_41619_() || !BacktankUtil.hasAirRemaining(backtank)) {
            return stack.m_41768_();
        }
        return true;
    }

    public static int getBarWidth(ItemStack stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return 13;
        }
        Player player = (Player)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91074_);
        if (player == null) {
            return 13;
        }
        ItemStack backtank = BacktankUtil.get((LivingEntity)player);
        if (backtank.m_41619_() || !BacktankUtil.hasAirRemaining(backtank)) {
            return Math.round(13.0f - (float)stack.m_41773_() / (float)stack.m_41776_() * 13.0f);
        }
        return backtank.m_41720_().m_142158_(backtank);
    }

    public static int getBarColor(ItemStack stack, int usesPerTank) {
        if (usesPerTank == 0) {
            return 0;
        }
        Player player = (Player)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91074_);
        if (player == null) {
            return 0;
        }
        ItemStack backtank = BacktankUtil.get((LivingEntity)player);
        if (backtank.m_41619_() || !BacktankUtil.hasAirRemaining(backtank)) {
            return Mth.m_14169_((float)(Math.max(0.0f, 1.0f - (float)stack.m_41773_() / (float)stack.m_41776_()) / 3.0f), (float)1.0f, (float)1.0f);
        }
        return backtank.m_41720_().m_142159_(backtank);
    }
}

