/*
 * Decompiled with CFR 0.152.
 */
package com.ofek2608.crafting_on_a_stick.integration;

import com.ofek2608.crafting_on_a_stick.CraftingOnAStick;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class COASCurios {
    private static final String MODID = "curios";
    private static final ResourceLocation CURIO_POCKET_ICON = CraftingOnAStick.loc("item/curios_on_a_stick");
    private static final String SLOT_ID = "crafting_on_a_stick";

    public static void load() {
    }

    public static boolean hasMod() {
        return ModList.get().isLoaded(MODID);
    }

    @Nullable
    public static IItemHandlerModifiable getCuriosInventory(Player player) {
        if (COASCurios.hasMod()) {
            return Integrator.getCuriosInventory(player);
        }
        return null;
    }

    public static IItemHandlerModifiable getFullInventory(Player player) {
        PlayerInvWrapper inventory = new PlayerInvWrapper(player.m_150109_());
        IItemHandlerModifiable curios = COASCurios.getCuriosInventory(player);
        return curios == null ? inventory : new CombinedInvWrapper(new IItemHandlerModifiable[]{inventory, curios});
    }

    static {
        if (COASCurios.hasMod()) {
            Integrator.init();
        }
    }

    private static final class Integrator {
        private Integrator() {
        }

        private static void init() {
            InterModComms.sendTo((String)COASCurios.MODID, (String)"register_type", () -> new SlotTypeMessage.Builder(COASCurios.SLOT_ID).icon(CURIO_POCKET_ICON).size(1).build());
        }

        @Nullable
        private static IItemHandlerModifiable getCuriosInventory(Player player) {
            Optional itemHandler = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).resolve();
            if (itemHandler.isEmpty()) {
                return null;
            }
            Optional stackHandler = ((ICuriosItemHandler)itemHandler.get()).getStacksHandler(COASCurios.SLOT_ID);
            if (stackHandler.isEmpty()) {
                return null;
            }
            return ((ICurioStacksHandler)stackHandler.get()).getStacks();
        }
    }

    @Mod.EventBusSubscriber(modid="crafting_on_a_stick", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    private static final class ModEvents {
        private ModEvents() {
        }

        @SubscribeEvent
        public static void event(TextureStitchEvent.Pre event) {
            event.addSprite(CURIO_POCKET_ICON);
        }
    }
}

