/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import ovh.corail.woodcutter.block.WoodcutterBlock;
import ovh.corail.woodcutter.config.ConfigWoodcutter;
import ovh.corail.woodcutter.inventory.WoodcutterContainer;
import ovh.corail.woodcutter.registry.ModBlocks;
import ovh.corail.woodcutter.registry.ModTabs;

@Mod.EventBusSubscriber(modid="corail_woodcutter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WoodcutterItem
extends BlockItem {
    private static final Component DEFAULT_DESCRIPTION = Component.m_237115_((String)"item.corail_woodcutter.woodcutter.desc").m_130940_(ChatFormatting.GRAY);
    private static final Component ACCESS_FROM_INVENTORY = Component.m_237115_((String)"item.corail_woodcutter.woodcutter.inventory").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC});

    public WoodcutterItem(Block woodcutterBlock) {
        super(woodcutterBlock, new Item.Properties().m_41491_(ModTabs.mainTab).m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flagIn) {
        list.add(DEFAULT_DESCRIPTION);
        if (((Boolean)ConfigWoodcutter.general.openWoodcutterInInventory.get()).booleanValue()) {
            list.add(ACCESS_FROM_INVENTORY);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (((Boolean)ConfigWoodcutter.general.openWoodcutterInInventory.get()).booleanValue() && hand == InteractionHand.MAIN_HAND && player.m_20163_()) {
            ItemStack heldItem = player.m_21120_(hand);
            if (!world.m_5776_()) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, playerInventory, p) -> new WoodcutterContainer(id, playerInventory), WoodcutterBlock.TRANSLATION));
            }
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        return super.m_7203_(world, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() != null && !(context.m_43723_() instanceof FakePlayer) && context.m_43724_() == InteractionHand.MAIN_HAND && context.m_43723_().m_20163_()) {
            return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
        }
        return super.m_6225_(context);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack heldStack;
        if (((Boolean)ConfigWoodcutter.general.openWoodcutterInInventory.get()).booleanValue() && event.getEntity() != null && !(event.getEntity() instanceof FakePlayer) && event.getEntity().m_20163_() && ModBlocks.WOODCUTTER_ITEMS.contains((heldStack = event.getEntity().m_21120_(event.getHand())).m_41720_())) {
            event.setCancellationResult(InteractionResult.PASS);
            event.setCanceled(true);
        }
    }
}

