/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.woodcutter.helper.Helper;
import ovh.corail.woodcutter.recipe.WoodcuttingRecipe;
import ovh.corail.woodcutter.registry.ModBlocks;
import ovh.corail.woodcutter.registry.ModMenuTypes;
import ovh.corail.woodcutter.registry.ModRecipeTypes;

public class WoodcutterContainer
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final Level level;
    private List<WoodcuttingRecipe> recipes = new ArrayList<WoodcuttingRecipe>();
    private ItemStack input = ItemStack.f_41583_;
    private long lastSoundTime;
    private final Slot inputSlot;
    private final Slot resultSlot;
    private Runnable slotUpdateListener = () -> {};
    private final Container inputInventory = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            WoodcutterContainer.this.m_6199_((Container)this);
            WoodcutterContainer.this.slotUpdateListener.run();
        }
    };
    private final ResultContainer resultContainer = new ResultContainer();

    public WoodcutterContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public WoodcutterContainer(int id, Inventory playerInventory, final ContainerLevelAccess access) {
        super(ModMenuTypes.WOODCUTTER, id);
        this.access = access;
        this.level = playerInventory.f_35978_.f_19853_;
        this.inputSlot = this.m_38897_(new Slot(this.inputInventory, 0, 20, 33));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 143, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player thePlayer, ItemStack stack) {
                stack.m_41678_(thePlayer.f_19853_, thePlayer, stack.m_41613_());
                WoodcutterContainer.this.resultContainer.m_8015_(thePlayer);
                ItemStack itemstack = WoodcutterContainer.this.inputSlot.m_6201_(1);
                if (!itemstack.m_41619_()) {
                    WoodcutterContainer.this.setupResultSlot();
                }
                access.m_39292_((world, pos) -> {
                    long l = world.m_46467_();
                    if (WoodcutterContainer.this.lastSoundTime != l) {
                        world.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        WoodcutterContainer.this.lastSoundTime = l;
                    }
                });
                super.m_142406_(thePlayer, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public List<WoodcuttingRecipe> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public boolean m_6875_(Player playerIn) {
        return (Boolean)this.access.m_39299_((world, pos) -> ModBlocks.WOODCUTTERS.contains(world.m_8055_(pos).m_60734_()) && playerIn.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    public boolean m_6366_(Player playerIn, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipeIndex.m_6422_(id);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int id) {
        return id >= 0 && id < this.recipes.size();
    }

    public void m_6199_(Container inventoryIn) {
        ItemStack stack = this.inputSlot.m_7993_();
        if (stack.m_41720_() != this.input.m_41720_()) {
            this.input = stack.m_41777_();
            this.setupRecipeList(inventoryIn, stack);
        }
    }

    private void setupRecipeList(Container inventoryIn, ItemStack stack) {
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        this.recipes = stack.m_41619_() ? Collections.emptyList() : Helper.getSortedMatchingRecipes(this.level, inventoryIn);
    }

    private void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            WoodcuttingRecipe recipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            this.resultContainer.m_6029_((Recipe)recipe);
            this.resultSlot.m_5852_(recipe.m_5874_(this.inputInventory));
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public MenuType<?> m_6772_() {
        return ModMenuTypes.WOODCUTTER;
    }

    public void registerUpdateListener(Runnable runnable) {
        this.slotUpdateListener = runnable;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn.f_40218_ != this.resultContainer && super.m_5882_(stack, slotIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            Item item = itemstack1.m_41720_();
            stack = itemstack1.m_41777_();
            if (index == 1) {
                item.m_7836_(itemstack1, playerIn.f_19853_, playerIn);
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, stack);
            } else if (index == 0 ? !this.m_38903_(itemstack1, 2, 38, false) : (this.level.m_7465_().m_44015_(ModRecipeTypes.WOODCUTTING, (Container)new SimpleContainer(new ItemStack[]{itemstack1}), this.level).isPresent() ? !this.m_38903_(itemstack1, 0, 1, false) : (index < 29 ? !this.m_38903_(itemstack1, 29, 38, false) : index < 38 && !this.m_38903_(itemstack1, 2, 29, false)))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (itemstack1.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
            this.m_38946_();
        }
        return stack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        if (this.access == ContainerLevelAccess.f_39287_) {
            ItemStack leftStack = this.inputInventory.m_8016_(0);
            if (!leftStack.m_41619_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)leftStack);
            }
        } else {
            this.access.m_39292_((world, pos) -> this.m_150411_(playerIn, this.inputInventory));
        }
        this.resultContainer.m_8016_(0);
    }
}

