/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass.model;

import com.google.common.base.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;

public class SideConnections {
    public final Direction side;
    private final BlockGetter level;
    private final Block block;
    public boolean left;
    public boolean right;
    public boolean up;
    public boolean up_left;
    public boolean up_right;
    public boolean down;
    public boolean down_left;
    public boolean down_right;

    public SideConnections(Direction side, BlockGetter level, BlockPos pos, Block block) {
        Direction down;
        Direction up;
        Direction right;
        Direction left;
        this.side = side;
        this.level = level;
        this.block = level.m_8055_(pos).m_60734_();
        if (side.m_122434_() == Direction.Axis.Y) {
            left = Direction.WEST;
            right = Direction.EAST;
            up = side == Direction.UP ? Direction.NORTH : Direction.SOUTH;
            down = side == Direction.UP ? Direction.SOUTH : Direction.NORTH;
        } else {
            left = side.m_122427_();
            right = side.m_122428_();
            up = Direction.UP;
            down = Direction.DOWN;
        }
        this.left = this.isSameBlock(pos.m_121945_(left));
        this.right = this.isSameBlock(pos.m_121945_(right));
        this.up = this.isSameBlock(pos.m_121945_(up));
        this.up_left = this.isSameBlock(pos.m_121945_(up).m_121945_(left));
        this.up_right = this.isSameBlock(pos.m_121945_(up).m_121945_(right));
        this.down = this.isSameBlock(pos.m_121945_(down));
        this.down_left = this.isSameBlock(pos.m_121945_(down).m_121945_(left));
        this.down_right = this.isSameBlock(pos.m_121945_(down).m_121945_(right));
    }

    private boolean isSameBlock(BlockPos pos) {
        return this.level.m_8055_(pos).m_60734_() == this.block;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SideConnections that = (SideConnections)o;
        return this.left == that.left && this.right == that.right && this.up == that.up && this.up_left == that.up_left && this.up_right == that.up_right && this.down == that.down && this.down_left == that.down_left && this.down_right == that.down_right && this.side == that.side;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.side, this.left, this.right, this.up, this.up_left, this.up_right, this.down, this.down_left, this.down_right});
    }
}

