/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command.subcommand;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.core.CMCommands;
import dev.compactmods.machines.api.core.Messages;
import dev.compactmods.machines.api.room.RoomSize;
import dev.compactmods.machines.dimension.Dimension;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.machine.CompactMachineBlock;
import dev.compactmods.machines.machine.CompactMachineBlockEntity;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.room.data.CompactRoomData;
import dev.compactmods.machines.room.exceptions.NonexistentRoomException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CMRoomsSubcommand {
    public static LiteralArgumentBuilder<CommandSourceStack> make() {
        LiteralArgumentBuilder subRoot = LiteralArgumentBuilder.literal((String)"rooms");
        subRoot.then(Commands.m_82127_((String)"machblock").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(CMRoomsSubcommand::fetchByMachineBlock)));
        subRoot.then(Commands.m_82127_((String)"findplayer").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(CMRoomsSubcommand::findByContainingPlayer)));
        subRoot.then(Commands.m_82127_((String)"ownedby").then(Commands.m_82129_((String)"owner", (ArgumentType)EntityArgument.m_91466_()).executes(CMRoomsSubcommand::findByOwner)));
        return subRoot;
    }

    private static int fetchByMachineBlock(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos block = BlockPosArgument.m_118242_(ctx, (String)"pos");
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        Block block2 = level.m_8055_(block).m_60734_();
        if (!(block2 instanceof CompactMachineBlock)) {
            throw new CommandRuntimeException((Component)TranslationUtil.command(CMCommands.NOT_A_MACHINE_BLOCK));
        }
        CompactMachineBlock b = (CompactMachineBlock)block2;
        BlockEntity blockEntity = level.m_7702_(block);
        if (blockEntity instanceof CompactMachineBlockEntity) {
            CompactMachineBlockEntity be = (CompactMachineBlockEntity)blockEntity;
            be.getConnectedRoom().ifPresent(room -> {
                MutableComponent m = TranslationUtil.message(Messages.MACHINE_ROOM_INFO, new Object[]{block, b.getSize(), room});
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)m, false);
            });
        }
        return 0;
    }

    private static int findByContainingPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
        ChunkPos playerChunk = player.m_146902_();
        ServerLevel playerLevel = player.m_9236_();
        if (!playerLevel.m_46472_().equals(Dimension.COMPACT_DIMENSION)) {
            throw new CommandRuntimeException((Component)TranslationUtil.command(CMCommands.WRONG_DIMENSION));
        }
        try {
            RoomSize roomSize = Rooms.sizeOf(server, playerChunk);
            MutableComponent m = TranslationUtil.message(Messages.PLAYER_ROOM_INFO, new Object[]{player.m_5446_(), playerChunk.toString(), roomSize});
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)m, false);
        }
        catch (NonexistentRoomException e) {
            CompactMachines.LOGGER.error("Player is inside an unregistered chunk ({}) in the compact world.", (Object)playerChunk, (Object)e);
            MutableComponent tc = Component.m_237113_((String)"%s, %s".formatted(playerChunk.f_45578_, playerChunk.f_45579_)).m_130940_(ChatFormatting.RED);
            throw new CommandRuntimeException((Component)TranslationUtil.message(Messages.UNKNOWN_ROOM_CHUNK, tc));
        }
        return 0;
    }

    public static int findByOwner(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer owner = EntityArgument.m_91474_(ctx, (String)"owner");
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
        ServerLevel compactDim = server.m_129880_(Dimension.COMPACT_DIMENSION);
        CompactRoomData rooms = CompactRoomData.get(compactDim);
        rooms.streamRooms().filter(r -> r.getOwner().equals(owner.m_20148_())).forEach(data -> ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237113_((String)("Room: " + new ChunkPos(data.getCenter()))), false));
        return 0;
    }
}

