/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.entity;

import cofh.core.util.helpers.ArcheryHelper;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;

public class ProjectileCoFH
extends Projectile {
    public ProjectileCoFH(EntityType<? extends ProjectileCoFH> type, Level level) {
        super(type, level);
    }

    public ProjectileCoFH(EntityType<? extends ProjectileCoFH> type, Level level, Entity owner, Vec3 position, Vec3 velocity) {
        this(type, level);
        this.m_5602_(owner);
        this.m_146884_(position);
        this.m_20256_(velocity);
        this.projectileTick(level);
        this.f_37246_ = true;
        this.m_146852_(GameEvent.f_157778_, owner);
        this.f_150164_ = true;
        this.updateVelocity();
        this.m_37283_();
    }

    protected void m_8097_() {
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_7310_(Entity entity) {
        return false;
    }

    public boolean m_7341_(Entity entity) {
        return false;
    }

    public void m_8119_() {
        this.f_19867_ = this.f_19787_;
        this.m_20157_();
        this.f_146809_ = this.f_146808_;
        this.f_146808_ = false;
        this.m_20073_();
        this.fireTick();
        this.m_146871_();
        this.m_146867_();
        this.projectileTick(this.f_19853_);
        this.m_20101_();
        this.updateVelocity();
        this.m_37283_();
        this.f_19803_ = false;
    }

    public void projectileTick(Level level) {
        Vec3 end;
        Vec3 start = this.m_20182_();
        Vec3 disp = end = start.m_82549_(this.m_20184_());
        BlockHitResult blockResult = this.blockRayTrace(level, start, end);
        if (blockResult.m_6662_() != HitResult.Type.MISS) {
            end = blockResult.m_82450_();
        }
        if (!this.hitEntities(level, start, end)) {
            if (blockResult.m_6662_() != HitResult.Type.MISS) {
                BlockPos blockpos = blockResult.m_82425_();
                BlockState blockstate = level.m_8055_(blockpos);
                if (blockstate.m_60713_(Blocks.f_50142_)) {
                    this.m_20221_(blockpos);
                } else {
                    if (blockstate.m_60713_(Blocks.f_50446_)) {
                        BlockEntity blockEntity = level.m_7702_(blockpos);
                        if (blockEntity instanceof TheEndGatewayBlockEntity) {
                            TheEndGatewayBlockEntity gateway = (TheEndGatewayBlockEntity)blockEntity;
                            if (TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                                TheEndGatewayBlockEntity.m_155828_((Level)level, (BlockPos)blockpos, (BlockState)blockstate, (Entity)this, (TheEndGatewayBlockEntity)gateway);
                            }
                        }
                        return;
                    }
                    if (ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)blockResult)) {
                        end = disp;
                    } else {
                        this.m_6532_((HitResult)blockResult);
                    }
                }
            }
            this.m_146884_(end);
        }
    }

    public BlockHitResult blockRayTrace(Level level, Vec3 startPos, Vec3 endPos) {
        return level.m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
    }

    public Stream<EntityHitResult> entityRayTrace(Level level, Vec3 startPos, Vec3 endPos) {
        return ArcheryHelper.findHitEntities(level, this, startPos, endPos, x$0 -> this.m_5603_((Entity)x$0));
    }

    public boolean hitEntities(Level level, Vec3 startPos, Vec3 endPos) {
        Vec3 pos = this.m_20182_();
        Optional<EntityHitResult> closest = this.entityRayTrace(level, startPos, endPos).sorted(Comparator.comparingDouble(result -> result.m_82450_().m_82557_(pos))).filter(result -> !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)result)).findFirst();
        if (closest.isPresent()) {
            this.m_6532_((HitResult)closest.get());
            return true;
        }
        return false;
    }

    public void updateVelocity() {
    }

    public void m_37283_() {
        Vec3 velocity = this.m_20184_();
        this.m_146926_((float)(Mth.m_14136_((double)velocity.f_82480_, (double)velocity.m_165924_()) * 57.29577951308232));
        this.m_146922_((float)(Mth.m_14136_((double)velocity.f_82479_, (double)velocity.f_82481_) * 57.29577951308232));
    }

    public void fireTick() {
        boolean inLava = this.m_20077_();
        if (inLava) {
            this.m_20093_();
            this.f_19789_ *= this.getFluidFallDistanceModifier((FluidType)ForgeMod.LAVA_TYPE.get());
        }
        if (this.f_19853_.f_46443_) {
            this.m_20095_();
        } else {
            if (this.f_19831_ > 0) {
                if (this.m_5825_()) {
                    this.m_20095_();
                } else {
                    if (this.f_19831_ % 20 == 0 && !inLava) {
                        this.m_6469_(DamageSource.f_19307_, 1.0f);
                    }
                    this.m_7311_(this.f_19831_ - 1);
                }
                if (this.m_146888_() > 0) {
                    this.m_146917_(0);
                    this.f_19853_.m_5898_(null, 1009, this.m_20183_(), 1);
                }
            }
            this.m_146868_(this.f_19831_ > 0);
        }
    }

    public SoundSource m_5720_() {
        Entity owner = this.m_37282_();
        return owner == null ? super.m_5720_() : owner.m_5720_();
    }
}

