/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.renderer.model;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.util.Constants;
import cofh.lib.util.helpers.MathHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.fluids.FluidStack;

public class ModelUtils {
    public static final ModelProperty<Direction> FACING = new ModelProperty();
    public static final ModelProperty<FluidStack> FLUID = new ModelProperty();
    public static final ModelProperty<Integer> LEVEL = new ModelProperty();
    public static final ModelProperty<byte[]> SIDES = new ModelProperty();
    public static final ModelProperty<ResourceLocation> UNDERLAY = new ModelProperty();

    private ModelUtils() {
    }

    public static class FluidCacheWrapper {
        BlockState state;
        FluidStack stack;

        public FluidCacheWrapper(BlockState state, FluidStack stack) {
            this.state = state;
            this.stack = new FluidStack(stack, 1000);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FluidCacheWrapper that = (FluidCacheWrapper)o;
            return Objects.equals(this.state, that.state) && Objects.equals(this.stack, that.stack);
        }

        public int hashCode() {
            return Objects.hash(this.state, FluidHelper.fluidHashcode(this.stack));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WrappedBakedModelBuilder {
        private final List<BakedQuad> builderGeneralQuads = new ArrayList<BakedQuad>();
        private final Map<Direction, List<BakedQuad>> builderUnderlayQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        private final Map<Direction, List<BakedQuad>> builderFaceQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        private final ItemOverrides builderItemOverrideList;
        private final boolean builderAmbientOcclusion;
        private TextureAtlasSprite builderTexture;
        private final boolean builderSideLit;
        private final boolean builderGui3d;
        private final ItemTransforms builderCameraTransforms;

        public WrappedBakedModelBuilder(BakedModel model) {
            for (Direction dir : Constants.DIRECTIONS) {
                this.builderUnderlayQuads.put(dir, new ArrayList());
                this.builderFaceQuads.put(dir, new LinkedList(model.m_213637_(null, dir, MathHelper.RANDOM)));
            }
            this.builderGeneralQuads.addAll(model.m_213637_(null, null, MathHelper.RANDOM));
            this.builderItemOverrideList = model.m_7343_();
            this.builderAmbientOcclusion = model.m_7541_();
            this.builderTexture = model.m_6160_();
            this.builderSideLit = model.m_7547_();
            this.builderGui3d = model.m_7539_();
            this.builderCameraTransforms = model.m_7442_();
        }

        public WrappedBakedModelBuilder addUnderlayQuad(Direction facing, BakedQuad quad) {
            this.builderUnderlayQuads.get(facing).add(quad);
            return this;
        }

        public WrappedBakedModelBuilder addFaceQuad(Direction facing, BakedQuad quad) {
            this.builderFaceQuads.get(facing).add(quad);
            return this;
        }

        public WrappedBakedModelBuilder addGeneralQuad(BakedQuad quad) {
            this.builderGeneralQuads.add(quad);
            return this;
        }

        public List<BakedQuad> getQuads(Direction facing) {
            return facing == null ? this.builderGeneralQuads : this.builderFaceQuads.get(facing);
        }

        public WrappedBakedModelBuilder setTexture(TextureAtlasSprite texture) {
            this.builderTexture = texture;
            return this;
        }

        public BakedModel build() {
            if (this.builderTexture == null) {
                throw new RuntimeException("Missing particle!");
            }
            for (Direction dir : Constants.DIRECTIONS) {
                this.builderUnderlayQuads.get(dir).addAll((Collection<BakedQuad>)this.builderFaceQuads.get(dir));
            }
            return new SimpleBakedModel(this.builderGeneralQuads, this.builderUnderlayQuads, this.builderAmbientOcclusion, this.builderSideLit, this.builderGui3d, this.builderTexture, this.builderCameraTransforms, this.builderItemOverrideList);
        }
    }
}

