/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.SpriteParticle;
import cofh.core.client.particle.options.ColorParticleOptions;
import cofh.core.util.helpers.vfx.Color;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FireParticle
extends SpriteParticle {
    protected int baseAlpha;

    private FireParticle(ColorParticleOptions data, ClientLevel level, SpriteSet sprites, double x, double y, double z, double dx, double dy, double dz) {
        super(data, level, sprites, x, y, z, dx, dy, dz);
        this.f_107226_ = -0.3f;
        this.f_172258_ = 0.9f;
        this.f_107204_ = this.f_107231_ = this.f_107223_.m_188501_() * ((float)Math.PI * 2);
        this.baseAlpha = data.rgba0 & 0xFF;
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, VertexConsumer consumer, int packedLight, float time, float pTicks) {
        float progress = time / this.duration;
        float easeCub = 1.0f - MathHelper.easeInCubic(progress);
        float easeCos = MathHelper.cos(progress * 0.5f * (float)Math.PI);
        this.setColor0(Color.fromFloat(this.c0.r, this.c0.g, this.c0.b, (int)((float)this.baseAlpha * easeCub)));
        this.size = this.f_107221_ * MathHelper.sin(0.7853982f * (progress + 1.0f));
        super.render(stack, buffer, consumer, packedLight, time, pTicks);
    }

    @Override
    public void m_5744_(VertexConsumer consumer, Camera cam, float partialTicks) {
        super.m_5744_(consumer, cam, partialTicks);
    }

    @Override
    public ParticleRenderType m_7556_() {
        return RenderTypes.PARTICLE_SHEET_ADDITIVE_MUTLIPLY;
    }

    @Override
    public int m_6355_(float partialTicks) {
        return 0xF000F0;
    }

    public void m_5989_() {
        super.m_5989_();
        this.sprite = this.sprites.m_5819_(this.f_107224_, this.f_107225_);
    }

    @Nonnull
    public static ParticleProvider<ColorParticleOptions> factory(SpriteSet spriteSet) {
        return (data, level, x, y, z, dx, dy, dz) -> new FireParticle((ColorParticleOptions)data, level, spriteSet, x, y, z, dx, dy, dz);
    }
}

