/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle;

import cofh.core.client.particle.ColorParticle;
import cofh.core.client.particle.options.ColorParticleOptions;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector4f;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class SpriteParticle
extends ColorParticle {
    protected final SpriteSet sprites;
    protected TextureAtlasSprite sprite;

    protected SpriteParticle(ColorParticleOptions data, ClientLevel level, SpriteSet sprites, double x, double y, double z, double dx, double dy, double dz) {
        super(data, level, x, y, z, dx, dy, dz);
        this.sprites = sprites;
        this.sprite = sprites.m_5819_(0, 1);
    }

    @Override
    public ParticleRenderType m_7556_() {
        return RenderTypes.PARTICLE_SHEET_TRANSLUCENT;
    }

    @Override
    public void setSize(float size) {
        float half = size * 0.5f;
        Vec3 pos = new Vec3(this.f_107212_, this.f_107213_ + (double)half, this.f_107214_);
        this.m_107259_(new AABB(pos, pos).m_82400_((double)half));
        this.f_107221_ = this.f_107222_ = size;
        super.setSize(size);
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, VertexConsumer consumer, int packedLight, float time, float pTicks) {
        Vector4f center = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        center.m_123607_(stack.m_85850_().m_85861_());
        float x = center.m_123601_();
        float y = center.m_123615_();
        float z = center.m_123616_() + 0.1f;
        float rot = MathHelper.interpolate(this.f_107204_, this.f_107231_, pTicks);
        float sin = MathHelper.sin(rot);
        float cos = MathHelper.cos(rot);
        float w = this.size * 0.5f;
        float a = w * (cos - sin);
        float b = w * (sin + cos);
        float u0 = this.sprite.m_118409_();
        float u1 = this.sprite.m_118410_();
        float v0 = this.sprite.m_118411_();
        float v1 = this.sprite.m_118412_();
        consumer.m_5483_((double)(x + a), (double)(y + b), (double)z).m_7421_(u1, v0).m_6122_(this.c0.r, this.c0.g, this.c0.b, this.c0.a).m_85969_(packedLight).m_5752_();
        consumer.m_5483_((double)(x - b), (double)(y + a), (double)z).m_7421_(u0, v0).m_6122_(this.c0.r, this.c0.g, this.c0.b, this.c0.a).m_85969_(packedLight).m_5752_();
        consumer.m_5483_((double)(x - a), (double)(y - b), (double)z).m_7421_(u0, v1).m_6122_(this.c0.r, this.c0.g, this.c0.b, this.c0.a).m_85969_(packedLight).m_5752_();
        consumer.m_5483_((double)(x + b), (double)(y - a), (double)z).m_7421_(u1, v1).m_6122_(this.c0.r, this.c0.g, this.c0.b, this.c0.a).m_85969_(packedLight).m_5752_();
    }
}

