/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle;

import cofh.core.client.particle.options.CoFHParticleOptions;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;

public abstract class CoFHParticle
extends Particle {
    protected float duration = 1.0f;
    protected float delay = 0.0f;
    protected float size = 1.0f;
    protected final int seed = this.f_107223_.m_188502_();

    public CoFHParticle(CoFHParticleOptions data, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
        super(level, x + dx, y + dy, z + dz);
        this.f_107209_ = x;
        this.f_107210_ = y;
        this.f_107211_ = z;
        this.f_107215_ = dx;
        this.f_107216_ = dy;
        this.f_107217_ = dz;
        this.setLifetime(data.duration, data.delay);
        this.setSize(data.size);
    }

    public void m_5744_(VertexConsumer consumer, Camera cam, float partialTicks) {
        float time = (float)this.f_107224_ + partialTicks - this.delay;
        if (time < 0.0f || time > this.duration) {
            return;
        }
        Vec3 camPos = cam.m_90583_();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        PoseStack stack = RenderHelper.particleStack;
        stack.m_85836_();
        double x = MathHelper.interpolate(this.f_107209_, this.f_107212_, (double)partialTicks);
        double y = MathHelper.interpolate(this.f_107210_, this.f_107213_, (double)partialTicks);
        double z = MathHelper.interpolate(this.f_107211_, this.f_107214_, (double)partialTicks);
        stack.m_85837_(x - camPos.f_82479_, y - camPos.f_82480_, z - camPos.f_82481_);
        this.render(stack, (MultiBufferSource)buffer, consumer, this.getLightColor(partialTicks, x, y, z), time, partialTicks);
        stack.m_85849_();
    }

    public abstract void render(PoseStack var1, MultiBufferSource var2, VertexConsumer var3, int var4, float var5, float var6);

    public ParticleRenderType m_7556_() {
        return RenderTypes.CUSTOM;
    }

    public int m_6355_(float pTicks) {
        double x = MathHelper.interpolate(this.f_107209_, this.f_107212_, (double)pTicks);
        double y = MathHelper.interpolate(this.f_107210_, this.f_107213_, (double)pTicks);
        double z = MathHelper.interpolate(this.f_107211_, this.f_107214_, (double)pTicks);
        return this.getLightColor(pTicks, x, y, z);
    }

    protected int getLightColor(float pTicks, double x, double y, double z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        return this.f_107208_.m_46805_(blockpos) ? LevelRenderer.m_109541_((BlockAndTintGetter)this.f_107208_, (BlockPos)blockpos) : 0;
    }

    protected void setLifetime(float duration, float delay) {
        this.delay = delay;
        this.duration = duration;
        this.f_107225_ = MathHelper.ceil(this.duration + delay);
    }

    protected void setSize(float size) {
        this.size = size;
    }
}

