/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.client;

import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.smashingmods.chemlib.api.Element;
import com.smashingmods.chemlib.registry.ItemRegistry;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class PeriodicTableScreen
extends Screen {
    public PeriodicTableScreen() {
        super((Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents("item.chemlib.periodic_table")));
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        int imageWidth = 2000;
        int imageHeight = 1016;
        int displayWidth = imageWidth / 4;
        int displayHeight = imageHeight / 4;
        int leftPos = (this.f_96543_ - displayWidth) / 2;
        int topPos = (this.f_96544_ - displayHeight) / 2;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("chemlib", "textures/gui/periodic_table.png"));
        PeriodicTableScreen.m_93160_((PoseStack)pPoseStack, (int)leftPos, (int)topPos, (int)displayWidth, (int)displayHeight, (float)0.0f, (float)0.0f, (int)imageWidth, (int)imageHeight, (int)imageWidth, (int)imageHeight);
        PeriodicTableScreen.m_93215_((PoseStack)pPoseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents("chemlib.screen.periodic_table")).m_130940_(ChatFormatting.BOLD), (int)(this.f_96543_ / 2), (int)24, (int)0xFFFFFF);
        double boxWidth = 27.75;
        double boxHeight = 26.9f;
        double startX = ((double)this.f_96543_ - 18.0 * boxWidth) / 2.0;
        double startY = ((double)this.f_96544_ - 7.0 * boxHeight) / 2.0 - 33.0;
        int count = 0;
        for (Element element : ItemRegistry.getElements()) {
            double x = startX;
            double y = startY;
            int group = element.getGroup();
            int period = element.getPeriod();
            for (int row = 1; row <= 7; ++row) {
                if (row == period) {
                    for (int col = 1; col <= 18; ++col) {
                        if (col == group) {
                            if (period != 6 && period != 7 || group != 3) {
                                if ((double)pMouseX >= x && (double)pMouseX < x + boxWidth && (double)pMouseY >= y && (double)pMouseY < y + boxHeight) {
                                    this.drawElementTip(pPoseStack, element);
                                }
                            } else {
                                double resetX = x;
                                double resetY = y;
                                if (period == 6) {
                                    y = boxHeight * (double)7.45f + startY;
                                    x = boxWidth * (double)count + startX + boxWidth * 2.0;
                                    if ((double)pMouseX >= x && (double)pMouseX < x + boxWidth && (double)pMouseY >= y && (double)pMouseY < y + boxHeight) {
                                        this.drawElementTip(pPoseStack, element);
                                    }
                                    ++count;
                                }
                                if (period == 7) {
                                    y = boxHeight * (double)8.45f + startY;
                                    x = boxWidth * (double)(count - 15) + startX + boxWidth * 2.0;
                                    if ((double)pMouseX >= x && (double)pMouseX < x + boxWidth && (double)pMouseY >= y && (double)pMouseY < y + boxHeight) {
                                        this.drawElementTip(pPoseStack, element);
                                    }
                                    ++count;
                                }
                                x = resetX;
                                y = resetY;
                            }
                        }
                        x += boxWidth;
                    }
                }
                x = startX;
                y += boxHeight;
            }
        }
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    private void drawElementTip(PoseStack pPoseStack, Element pElement) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("chemlib", String.format("textures/gui/elements/%s_tooltip.png", pElement.getChemicalName())));
        PeriodicTableScreen.m_93160_((PoseStack)pPoseStack, (int)((this.f_96543_ - 276) / 2 - 55), (int)((this.f_96544_ - 196) / 2 - 30), (int)274, (int)80, (float)0.0f, (float)0.0f, (int)40, (int)40, (int)40, (int)40);
    }

    public boolean m_7043_() {
        return false;
    }
}

