/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.shared.TurtlePermissions;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.core.TurtlePlaceCommand;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;

public class TurtleTool
extends AbstractTurtleUpgrade {
    protected static final TurtleCommandResult UNBREAKABLE = TurtleCommandResult.failure("Cannot break unbreakable block");
    protected static final TurtleCommandResult INEFFECTIVE = TurtleCommandResult.failure("Cannot break block with this tool");
    final ItemStack item;
    final float damageMulitiplier;
    @Nullable
    final TagKey<Block> breakable;

    public TurtleTool(ResourceLocation id, String adjective, Item craftItem, ItemStack toolItem, float damageMulitiplier, @Nullable TagKey<Block> breakable) {
        super(id, TurtleUpgradeType.TOOL, adjective, new ItemStack((ItemLike)craftItem));
        this.item = toolItem;
        this.damageMulitiplier = damageMulitiplier;
        this.breakable = breakable;
    }

    @Override
    public boolean isItemSuitable(@Nonnull ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || tag.m_128456_()) {
            return true;
        }
        if (stack.m_41768_() || stack.m_41793_() || stack.m_41788_()) {
            return false;
        }
        return !tag.m_128425_("AttributeModifiers", 9) || tag.m_128437_("AttributeModifiers", 10).isEmpty();
    }

    @Override
    @Nonnull
    public TurtleCommandResult useTool(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side, @Nonnull TurtleVerb verb, @Nonnull Direction direction) {
        switch (verb) {
            case ATTACK: {
                return this.attack(turtle, direction);
            }
            case DIG: {
                return this.dig(turtle, direction);
            }
        }
        return TurtleCommandResult.failure("Unsupported action");
    }

    protected TurtleCommandResult checkBlockBreakable(BlockState state, Level world, BlockPos pos, TurtlePlayer player) {
        Block block = state.m_60734_();
        if (state.m_60795_() || block == Blocks.f_50752_ || state.m_60625_((Player)player, (BlockGetter)world, pos) <= 0.0f || !block.canEntityDestroy(state, (BlockGetter)world, pos, (Entity)player)) {
            return UNBREAKABLE;
        }
        return this.breakable == null || state.m_204336_(this.breakable) || this.isTriviallyBreakable((BlockGetter)world, pos, state) ? TurtleCommandResult.success() : INEFFECTIVE;
    }

    private TurtleCommandResult attack(ITurtleAccess turtle, Direction direction) {
        Vec3 rayDir;
        BlockPos position;
        TurtlePlayer turtlePlayer;
        Vec3 turtlePos;
        Level world = turtle.getLevel();
        Pair<Entity, Vec3> hit = WorldUtil.rayTraceEntities(world, turtlePos = (turtlePlayer = TurtlePlayer.getWithPosition(turtle, position = turtle.getPosition(), direction)).m_20182_(), rayDir = turtlePlayer.m_20252_(1.0f), 1.5);
        if (hit != null) {
            float damage;
            ItemStack stackCopy = this.item.m_41777_();
            turtlePlayer.loadInventory(stackCopy);
            Entity hitEntity = (Entity)hit.getKey();
            if (MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((Player)turtlePlayer, hitEntity)) || !hitEntity.m_6097_()) {
                return TurtleCommandResult.failure("Nothing to attack here");
            }
            DropConsumer.set(hitEntity, TurtleUtil.dropConsumer(turtle));
            boolean attacked = false;
            if (!hitEntity.m_7313_((Entity)turtlePlayer) && (damage = (float)turtlePlayer.m_21133_(Attributes.f_22281_) * this.damageMulitiplier) > 0.0f) {
                DamageSource source = DamageSource.m_19344_((Player)turtlePlayer);
                if (hitEntity instanceof ArmorStand) {
                    hitEntity.m_6469_(source, damage);
                    if (hitEntity.m_6084_()) {
                        hitEntity.m_6469_(source, damage);
                    }
                    attacked = true;
                } else if (hitEntity.m_6469_(source, damage)) {
                    attacked = true;
                }
            }
            TurtleUtil.stopConsuming(turtle);
            if (attacked) {
                turtlePlayer.m_150109_().m_6211_();
                return TurtleCommandResult.success();
            }
        }
        return TurtleCommandResult.failure("Nothing to attack here");
    }

    private TurtleCommandResult dig(ITurtleAccess turtle, Direction direction) {
        TurtleCommandResult breakable;
        BlockPos turtlePosition;
        BlockPos blockPosition;
        if ((this.item.canPerformAction(ToolActions.SHOVEL_FLATTEN) || this.item.canPerformAction(ToolActions.HOE_TILL)) && TurtlePlaceCommand.deployCopiedItem(this.item.m_41777_(), turtle, direction, null, null)) {
            return TurtleCommandResult.success();
        }
        Level world = turtle.getLevel();
        if (world.m_46859_(blockPosition = (turtlePosition = turtle.getPosition()).m_121945_(direction)) || WorldUtil.isLiquidBlock(world, blockPosition)) {
            return TurtleCommandResult.failure("Nothing to dig here");
        }
        BlockState state = world.m_8055_(blockPosition);
        FluidState fluidState = world.m_6425_(blockPosition);
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, turtlePosition, direction);
        turtlePlayer.loadInventory(this.item.m_41777_());
        if (ComputerCraft.turtlesObeyBlockProtection) {
            if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, blockPosition, state, (Player)turtlePlayer))) {
                return TurtleCommandResult.failure("Cannot break protected block");
            }
            if (!TurtlePermissions.isBlockEditable(world, blockPosition, (Player)turtlePlayer)) {
                return TurtleCommandResult.failure("Cannot break protected block");
            }
        }
        if (!(breakable = this.checkBlockBreakable(state, world, blockPosition, turtlePlayer)).isSuccess()) {
            return breakable;
        }
        DropConsumer.set(world, blockPosition, TurtleUtil.dropConsumer(turtle));
        BlockEntity tile = world.m_7702_(blockPosition);
        world.m_46796_(2001, blockPosition, Block.m_49956_((BlockState)state));
        boolean canHarvest = state.canHarvestBlock((BlockGetter)world, blockPosition, (Player)turtlePlayer);
        boolean canBreak = state.onDestroyedByPlayer(world, blockPosition, (Player)turtlePlayer, canHarvest, fluidState);
        if (canBreak) {
            state.m_60734_().m_6786_((LevelAccessor)world, blockPosition, state);
        }
        if (canHarvest && canBreak) {
            state.m_60734_().m_6240_(world, (Player)turtlePlayer, blockPosition, state, tile, turtlePlayer.m_21205_());
        }
        TurtleUtil.stopConsuming(turtle);
        return TurtleCommandResult.success();
    }

    protected boolean isTriviallyBreakable(BlockGetter reader, BlockPos pos, BlockState state) {
        return state.m_204336_(ComputerCraftTags.Blocks.TURTLE_ALWAYS_BREAKABLE) || state.m_60800_(reader, pos) == 0.0f;
    }
}

