/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic.data;

import com.google.gson.JsonParseException;
import dan200.computercraft.shared.peripheral.generic.data.DataHelpers;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemData {
    @Nonnull
    public static <T extends Map<? super String, Object>> T fillBasicSafe(@Nonnull T data, @Nonnull ItemStack stack) {
        data.put((String)"name", (String)DataHelpers.getId(ForgeRegistries.ITEMS, stack.m_41720_()));
        data.put((String)"count", stack.m_41613_());
        return data;
    }

    public static void fillBasic(@Nonnull Map<? super String, Object> data, @Nonnull ItemStack stack) {
        ItemData.fillBasicSafe(data, stack);
        String hash = NBTUtil.getNBTHash(stack.m_41783_());
        if (hash != null) {
            data.put("nbt", hash);
        }
    }

    public static void fill(@Nonnull Map<? super String, Object> data, @Nonnull ItemStack stack) {
        int hideFlags;
        List<Map<String, Object>> enchants;
        CompoundTag displayTag;
        data.put("displayName", stack.m_41786_().getString());
        data.put("maxCount", stack.m_41741_());
        if (stack.m_41763_()) {
            data.put("damage", stack.m_41773_());
            data.put("maxDamage", stack.m_41776_());
        }
        if (stack.m_41720_().m_142522_(stack)) {
            data.put("durability", (double)stack.m_41720_().m_142158_(stack) / 13.0);
        }
        data.put("tags", DataHelpers.getTags(stack.m_204131_()));
        data.put("itemGroups", ItemData.getItemGroups(stack));
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("display", 10) && (displayTag = tag.m_128469_("display")).m_128425_("Lore", 9)) {
            ListTag loreTag = displayTag.m_128437_("Lore", 8);
            data.put("lore", loreTag.stream().map(ItemData::parseTextComponent).filter(Objects::nonNull).map(Component::getString).toList());
        }
        if (!(enchants = ItemData.getAllEnchants(stack, hideFlags = tag != null ? tag.m_128451_("HideFlags") : 0)).isEmpty()) {
            data.put("enchantments", enchants);
        }
        if (tag != null && tag.m_128471_("Unbreakable") && (hideFlags & 4) == 0) {
            data.put("unbreakable", true);
        }
    }

    @Nullable
    private static Component parseTextComponent(@Nonnull Tag x) {
        try {
            return Component.Serializer.m_130701_((String)x.m_7916_());
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    @Nonnull
    private static List<Map<String, Object>> getItemGroups(@Nonnull ItemStack stack) {
        ArrayList<Map<String, Object>> groups = new ArrayList<Map<String, Object>>(1);
        for (CreativeModeTab group : stack.m_41720_().getCreativeTabs()) {
            if (group == null) continue;
            HashMap<String, String> groupData = new HashMap<String, String>(2);
            groupData.put("id", group.f_40763_);
            groupData.put("displayName", group.m_40786_().getString());
            groups.add(groupData);
        }
        return groups;
    }

    @Nonnull
    private static List<Map<String, Object>> getAllEnchants(@Nonnull ItemStack stack, int hideFlags) {
        ArrayList<Map<String, Object>> enchants = new ArrayList<Map<String, Object>>(0);
        if (stack.m_41720_() instanceof EnchantedBookItem && (hideFlags & 0x20) == 0) {
            ItemData.addEnchantments(EnchantedBookItem.m_41163_((ItemStack)stack), enchants);
        }
        if (stack.m_41793_() && (hideFlags & 1) == 0) {
            ItemData.addEnchantments(stack.m_41785_(), enchants);
        }
        return enchants;
    }

    private static void addEnchantments(@Nonnull ListTag rawEnchants, @Nonnull ArrayList<Map<String, Object>> enchants) {
        if (rawEnchants.isEmpty()) {
            return;
        }
        enchants.ensureCapacity(enchants.size() + rawEnchants.size());
        for (Map.Entry entry : EnchantmentHelper.m_44882_((ListTag)rawEnchants).entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer level = (Integer)entry.getValue();
            HashMap<String, Object> enchant = new HashMap<String, Object>(3);
            enchant.put("name", DataHelpers.getId(ForgeRegistries.ENCHANTMENTS, enchantment));
            enchant.put("level", level);
            enchant.put("displayName", enchantment.m_44700_(level.intValue()).getString());
            enchants.add(enchant);
        }
    }
}

