/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.shared.network.NetworkMessage;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PlayRecordClientMessage
implements NetworkMessage {
    private final BlockPos pos;
    private final String name;
    private final SoundEvent soundEvent;

    public PlayRecordClientMessage(BlockPos pos, SoundEvent event, String name) {
        this.pos = pos;
        this.name = name;
        this.soundEvent = event;
    }

    public PlayRecordClientMessage(BlockPos pos) {
        this.pos = pos;
        this.name = null;
        this.soundEvent = null;
    }

    public PlayRecordClientMessage(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        if (buf.readBoolean()) {
            this.name = buf.m_130136_(Short.MAX_VALUE);
            this.soundEvent = (SoundEvent)buf.readRegistryIdSafe(SoundEvent.class);
        } else {
            this.name = null;
            this.soundEvent = null;
        }
    }

    @Override
    public void toBytes(@Nonnull FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        if (this.soundEvent == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.m_130070_(this.name);
            buf.writeRegistryId(ForgeRegistries.SOUND_EVENTS, (Object)this.soundEvent);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(NetworkEvent.Context context) {
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91060_.playStreamingMusic(this.soundEvent, this.pos, null);
        if (this.name != null) {
            mc.f_91065_.m_93055_((Component)Component.m_237113_((String)this.name));
        }
    }
}

