/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft", value={Dist.CLIENT})
public class DebugOverlay {
    @SubscribeEvent
    public static void onRenderText(CustomizeGuiOverlayEvent.DebugText event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!minecraft.f_91066_.f_92063_ || minecraft.f_91073_ == null) {
            return;
        }
        if (minecraft.f_91077_ == null || minecraft.f_91077_.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockEntity tile = minecraft.f_91073_.m_7702_(((BlockHitResult)minecraft.f_91077_).m_82425_());
        if (tile instanceof TileMonitor) {
            TileMonitor monitor = (TileMonitor)tile;
            event.getRight().add("");
            event.getRight().add(String.format("Targeted monitor: (%d, %d), %d x %d", monitor.getXIndex(), monitor.getYIndex(), monitor.getWidth(), monitor.getHeight()));
        } else if (tile instanceof TileTurtle) {
            TileTurtle turtle = (TileTurtle)tile;
            event.getRight().add("");
            event.getRight().add("Targeted turtle:");
            event.getRight().add(String.format("Id: %d", turtle.getComputerID()));
            DebugOverlay.addTurtleUpgrade(event.getRight(), turtle, TurtleSide.LEFT);
            DebugOverlay.addTurtleUpgrade(event.getRight(), turtle, TurtleSide.RIGHT);
        }
    }

    private static void addTurtleUpgrade(List<String> out, TileTurtle turtle, TurtleSide side) {
        ITurtleUpgrade upgrade = turtle.getUpgrade(side);
        if (upgrade != null) {
            out.add(String.format("Upgrade[%s]: %s", new Object[]{side, upgrade.getUpgradeID()}));
        }
    }
}

