/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.inventory.materials;

import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.AndMaterialListEntry;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialListEntry;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.OrMaterialListEntry;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.SimpleMaterialListEntry;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.SubMaterialListEntry;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.util.ref.NBTKeys;
import com.direwolf20.buildinggadgets.common.util.tools.JsonBiDiSerializer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.PeekingIterator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public final class MaterialList
implements Iterable<ImmutableMultiset<IUniqueObject<?>>> {
    private static final MaterialList EMPTY = new MaterialList();
    private final MaterialListEntry rootEntry;

    public static MaterialList deserialize(CompoundTag nbt, boolean persisted) {
        return new MaterialList(MaterialList.readEntry(nbt, persisted));
    }

    public static MaterialList empty() {
        return EMPTY;
    }

    public static MaterialList of() {
        return MaterialList.empty();
    }

    public static MaterialList of(IUniqueObject<?> ... items) {
        return MaterialList.simpleBuilder().add(items).build();
    }

    public static MaterialList of(Iterable<IUniqueObject<?>> items) {
        return MaterialList.simpleBuilder().addAll(items).build();
    }

    public static MaterialList and(MaterialList ... materialLists) {
        return MaterialList.andBuilder().add(materialLists).build();
    }

    public static MaterialList or(MaterialList ... materialLists) {
        return MaterialList.orBuilder().add(materialLists).build();
    }

    public static SimpleBuilder simpleBuilder() {
        return new SimpleBuilder();
    }

    public static SubEntryBuilder andBuilder() {
        return new SubEntryBuilder(AndMaterialListEntry::new);
    }

    public static SubEntryBuilder orBuilder() {
        return new SubEntryBuilder(OrMaterialListEntry::new);
    }

    @Nullable
    static MaterialListEntry.Serializer<?> getSerializerForId(ResourceLocation id) {
        MaterialListEntry.Serializer<MaterialListEntry<SimpleMaterialListEntry>> serializer = null;
        if (id.equals((Object)NBTKeys.SIMPLE_SERIALIZER_ID)) {
            serializer = SimpleMaterialListEntry.SERIALIZER;
        } else if (id.equals((Object)NBTKeys.OR_SERIALIZER_ID)) {
            serializer = OrMaterialListEntry.SERIALIZER;
        } else if (id.equals((Object)NBTKeys.AND_SERIALIZER_ID)) {
            serializer = AndMaterialListEntry.SERIALIZER;
        }
        return serializer;
    }

    static MaterialListEntry<?> readEntry(CompoundTag nbt, boolean persisted) {
        ResourceLocation id = new ResourceLocation(nbt.m_128461_("serializer"));
        MaterialListEntry.Serializer<?> serializer = MaterialList.getSerializerForId(id);
        Preconditions.checkArgument((serializer != null ? 1 : 0) != 0, (Object)("Failed to recognize Serializer " + id + "! If you believe you need another implementation, please contact us and we can sort something out!"));
        return serializer.readFromNBT(nbt, persisted);
    }

    static CompoundTag writeEntry(MaterialListEntry entry, boolean persisted) {
        assert (entry.getSerializer().getRegistryName() != null);
        CompoundTag res = new CompoundTag();
        res.m_128359_("serializer", entry.getSerializer().getRegistryName().toString());
        res.m_128365_("data", (Tag)entry.getSerializer().writeToNBT(entry, persisted));
        return res;
    }

    private MaterialList() {
        this(new SimpleMaterialListEntry(ImmutableMultiset.of()));
    }

    private MaterialList(MaterialListEntry rootEntry) {
        this.rootEntry = Objects.requireNonNull(rootEntry, "Cannot have a MaterialList without a root entry!");
    }

    private MaterialListEntry getRootEntry() {
        return this.rootEntry;
    }

    public Iterable<ImmutableMultiset<IUniqueObject<?>>> getItemOptions() {
        return this.rootEntry instanceof SubMaterialListEntry ? ((SubMaterialListEntry)this.rootEntry).viewOnlySubEntries() : ImmutableList.of();
    }

    public ImmutableMultiset<IUniqueObject<?>> getRequiredItems() {
        SimpleMaterialListEntry simpleEntry = this.rootEntry instanceof SubMaterialListEntry ? ((SubMaterialListEntry)this.rootEntry).getCombinedConstantEntry() : (SimpleMaterialListEntry)this.rootEntry;
        return simpleEntry.getItems();
    }

    public CompoundTag serialize(boolean persisted) {
        return MaterialList.writeEntry(this.rootEntry, persisted);
    }

    @Override
    public PeekingIterator<ImmutableMultiset<IUniqueObject<?>>> iterator() {
        return this.getRootEntry().iterator();
    }

    public static final class SimpleBuilder {
        private ImmutableMultiset.Builder<IUniqueObject<?>> requiredItems = ImmutableMultiset.builder();

        private SimpleBuilder() {
        }

        public SimpleBuilder addItem(IUniqueObject<?> item, int count) {
            this.requiredItems.addCopies(item, count);
            return this;
        }

        public SimpleBuilder addItem(IUniqueObject<?> item) {
            return this.addItem(item, 1);
        }

        public SimpleBuilder addAll(Iterable<IUniqueObject<?>> items) {
            this.requiredItems.addAll(items);
            return this;
        }

        public SimpleBuilder setCount(IUniqueObject<?> element, int count) {
            this.requiredItems.setCount(element, count);
            return this;
        }

        public SimpleBuilder add(IUniqueObject<?> ... elements) {
            this.requiredItems.add((Object[])elements);
            return this;
        }

        public SimpleBuilder addAll(Iterator<? extends IUniqueObject<?>> elements) {
            this.requiredItems.addAll(elements);
            return this;
        }

        public MaterialList build() {
            return new MaterialList(new SimpleMaterialListEntry(this.requiredItems.build()));
        }
    }

    public static final class SubEntryBuilder {
        private ImmutableList.Builder<MaterialListEntry<?>> subBuilder = ImmutableList.builder();
        private final Function<ImmutableList<MaterialListEntry<?>>, MaterialListEntry<?>> factory;

        private SubEntryBuilder(Function<ImmutableList<MaterialListEntry<?>>, MaterialListEntry<?>> factory) {
            this.factory = factory;
        }

        public SubEntryBuilder add(SimpleBuilder builder) {
            return this.add(builder.build());
        }

        public SubEntryBuilder add(SimpleBuilder ... builders) {
            return this.addAllSimpleBuilders(Arrays.asList(builders));
        }

        public SubEntryBuilder add(SubEntryBuilder builder) {
            return this.add(builder.build());
        }

        public SubEntryBuilder add(SubEntryBuilder ... builders) {
            return this.addAllSubBuilders(Arrays.asList(builders));
        }

        public SubEntryBuilder add(MaterialList element) {
            this.subBuilder.add((Object)element.getRootEntry());
            return this;
        }

        public SubEntryBuilder add(MaterialList ... elements) {
            return this.addAll(Arrays.asList(elements));
        }

        public SubEntryBuilder addItems(Multiset<IUniqueObject<?>> items) {
            this.subBuilder.add((Object)new SimpleMaterialListEntry(ImmutableMultiset.copyOf(items)));
            return this;
        }

        public SubEntryBuilder addAllItems(Iterable<? extends Multiset<IUniqueObject<?>>> iterable) {
            iterable.forEach(this::addItems);
            return this;
        }

        public SubEntryBuilder addAll(Iterable<MaterialList> elements) {
            elements.forEach(this::add);
            return this;
        }

        public SubEntryBuilder addAll(Iterator<MaterialList> elements) {
            elements.forEachRemaining(this::add);
            return this;
        }

        public SubEntryBuilder addAllSimpleBuilders(Iterable<SimpleBuilder> iterable) {
            iterable.forEach(this::add);
            return this;
        }

        public SubEntryBuilder addAllSubBuilders(Iterable<SubEntryBuilder> iterable) {
            iterable.forEach(this::add);
            return this;
        }

        public MaterialList build() {
            return new MaterialList(this.factory.apply(this.subBuilder.build()).simplify());
        }
    }

    public static final class JsonSerializer
    implements JsonBiDiSerializer<MaterialList> {
        private final boolean printName;
        private final boolean extended;

        public JsonSerializer(boolean printName, boolean extended) {
            this.printName = printName;
            this.extended = extended;
        }

        public JsonElement serialize(MaterialList src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject res = new JsonObject();
            res.add("root_type", context.serialize((Object)src.getRootEntry().getSerializer().getRegistryName()));
            res.add("root_entry", src.getRootEntry().getSerializer().asJsonSerializer(this.printName, this.extended).serialize((Object)src.getRootEntry(), src.getRootEntry().getClass(), context));
            return res;
        }

        public MaterialList deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonNull()) {
                return MaterialList.empty();
            }
            JsonObject object = json.getAsJsonObject();
            MaterialListEntry.Serializer<?> serializer = MaterialList.getSerializerForId((ResourceLocation)context.deserialize(object.get("root_type"), ResourceLocation.class));
            if (serializer == null) {
                return MaterialList.empty();
            }
            JsonDeserializer<?> jsonSerializer = serializer.asJsonDeserializer();
            return new MaterialList((MaterialListEntry)jsonSerializer.deserialize(object.get("root_entry"), MaterialListEntry.class, context));
        }
    }
}

