/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.capability;

import com.direwolf20.buildinggadgets.common.capability.ConfigEnergyStorage;
import com.direwolf20.buildinggadgets.common.capability.IPrivateEnergy;
import java.util.function.IntSupplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public final class ItemEnergyForge
extends ConfigEnergyStorage
implements IPrivateEnergy {
    private final ItemStack stack;

    public ItemEnergyForge(ItemStack stack, IntSupplier capacity) {
        super(capacity);
        this.stack = stack;
    }

    @Override
    protected void writeEnergy() {
        CompoundTag nbt = this.stack.m_41784_();
        nbt.m_128405_("energy", this.getEnergyStoredCache());
    }

    @Override
    protected void updateEnergy() {
        CompoundTag nbt = this.stack.m_41784_();
        if (nbt.m_128441_("energy")) {
            this.setEnergy(nbt.m_128451_("energy"));
        }
        this.updateMaxEnergy();
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int extractPower(int maxExtract, boolean simulate) {
        if (maxExtract < 0) {
            return 0;
        }
        int energyExtracted = this.evaluateEnergyExtracted(maxExtract, simulate);
        if (!simulate) {
            this.setEnergy(this.getEnergyStored() - energyExtracted);
            this.writeEnergy();
        }
        return energyExtracted;
    }
}

