/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.screen.GuiMod;
import com.direwolf20.buildinggadgets.client.screen.widgets.IncrementalSliderWidget;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketDestructionGUI;
import com.direwolf20.buildinggadgets.common.util.lang.GuiTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class DestructionGUI
extends Screen {
    private final Set<IncrementalSliderWidget> sliders = new HashSet<IncrementalSliderWidget>();
    private IncrementalSliderWidget left;
    private IncrementalSliderWidget right;
    private IncrementalSliderWidget up;
    private IncrementalSliderWidget down;
    private IncrementalSliderWidget depth;
    private Button confirm;
    private String sizeString = "";
    private boolean isValidSize = true;
    private final ItemStack destructionGadget;

    public DestructionGUI(ItemStack tool) {
        super((Component)Component.m_237119_());
        this.destructionGadget = tool;
    }

    public void m_7856_() {
        super.m_7856_();
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        this.confirm = new Button(x - 30 + 32, y + 65, 60, 20, (Component)Component.m_237115_((String)GuiMod.getLangKeySingle("confirm")), b -> {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return;
            }
            if (this.isWithinBounds()) {
                PacketHandler.sendToServer(new PacketDestructionGUI(this.left.getValueInt(), this.right.getValueInt(), this.up.getValueInt(), this.down.getValueInt(), this.depth.getValueInt()));
                this.m_7379_();
            } else {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)MessageTranslation.DESTRCUT_TOO_LARGE.componentTranslation(Config.GADGETS.GADGET_DESTRUCTION.destroySize.get()), true);
            }
        });
        this.m_142416_((GuiEventListener)this.confirm);
        this.m_142416_((GuiEventListener)new Button(x - 30 - 32, y + 65, 60, 20, (Component)Component.m_237115_((String)GuiMod.getLangKeySingle("cancel")), b -> this.m_7379_()));
        this.sliders.clear();
        this.depth = this.createSlider(x - 35, y - 7, GuiTranslation.SINGLE_DEPTH, GadgetDestruction.getToolValue(this.destructionGadget, "depth"));
        this.sliders.add(this.depth);
        this.right = this.createSlider(x + 75, y - 7, GuiTranslation.SINGLE_RIGHT, GadgetDestruction.getToolValue(this.destructionGadget, "right"));
        this.sliders.add(this.right);
        this.left = this.createSlider(x - 140 - 5, y - 7, GuiTranslation.SINGLE_LEFT, GadgetDestruction.getToolValue(this.destructionGadget, "left"));
        this.sliders.add(this.left);
        this.up = this.createSlider(x - 35, y - 35, GuiTranslation.SINGLE_UP, GadgetDestruction.getToolValue(this.destructionGadget, "up"));
        this.sliders.add(this.up);
        this.down = this.createSlider(x - 35, y + 20, GuiTranslation.SINGLE_DOWN, GadgetDestruction.getToolValue(this.destructionGadget, "down"));
        this.sliders.add(this.down);
        this.updateSizeString();
        this.updateIsValid();
        this.sliders.forEach(gui -> gui.getComponents().forEach(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }));
    }

    public IncrementalSliderWidget createSlider(int x, int y, GuiTranslation prefix, int value) {
        return new IncrementalSliderWidget(x, y, 70, 14, 0.0, 16.0, (Component)prefix.componentTranslation(new Object[0]).m_130946_(": "), value, this::onSliderUpdate);
    }

    public void onSliderUpdate(IncrementalSliderWidget widget) {
        this.updateSizeString();
        this.updateIsValid();
    }

    private boolean isWithinBounds() {
        int x = 1 + this.left.getValueInt() + this.right.getValueInt();
        int y = 1 + this.up.getValueInt() + this.down.getValueInt();
        int z = this.depth.getValueInt();
        int dim = (Integer)Config.GADGETS.GADGET_DESTRUCTION.destroySize.get();
        return x <= dim + 1 && y <= dim + 1 && z <= dim;
    }

    private String getSizeString() {
        int x = 1 + this.left.getValueInt() + this.right.getValueInt();
        int y = 1 + this.up.getValueInt() + this.down.getValueInt();
        int z = this.depth.getValueInt();
        return String.format("%d x %d x %d", x, y, z);
    }

    private void updateIsValid() {
        this.isValidSize = this.isWithinBounds();
        if (!this.isValidSize && this.confirm.f_93623_) {
            this.confirm.setFGColor(0xFF2000);
            this.confirm.f_93623_ = false;
        }
        if (this.isValidSize && !this.confirm.f_93623_) {
            this.confirm.clearFGColor();
            this.confirm.f_93623_ = true;
        }
    }

    private void updateSizeString() {
        this.sizeString = this.getSizeString();
    }

    public void m_6305_(@Nonnull PoseStack matrices, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrices, mouseX, mouseY, partialTicks);
        DestructionGUI.m_93208_((PoseStack)matrices, (Font)this.f_96547_, (String)this.sizeString, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + 40), (int)(this.isValidSize ? 65280 : 0xFF2000));
        if (!this.isValidSize) {
            DestructionGUI.m_93208_((PoseStack)matrices, (Font)this.f_96547_, (String)MessageTranslation.DESTRCUT_TOO_LARGE.format(Config.GADGETS.GADGET_DESTRUCTION.destroySize.get()), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + 50), (int)0xFF2000);
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7043_() {
        return false;
    }
}

