/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.blueflame.cap;

import cy.jdkdigital.blueflame.BlueFlame;
import cy.jdkdigital.blueflame.cap.IBlueFlameProvider;
import cy.jdkdigital.blueflame.network.FirePacket;
import cy.jdkdigital.blueflame.network.PacketHandler;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class BlueFlameImpl {

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        public static final ResourceLocation NAME = new ResourceLocation("blueflame", "blue_flame_on");
        private final DefaultImpl impl;
        private final LazyOptional<IBlueFlameProvider> cap;

        public Provider(Entity entity) {
            this.impl = new DefaultImpl(entity);
            this.cap = LazyOptional.of(() -> this.impl);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
            if (capability == BlueFlame.BLUE_FLAME_CAPABILITY) {
                return this.cap.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.impl.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.impl.deserializeNBT(nbt);
        }
    }

    private static class DefaultImpl
    implements IBlueFlameProvider {
        private final Entity entity;
        private boolean isOnFire = false;

        private DefaultImpl(Entity entity) {
            this.entity = entity;
        }

        @Override
        public boolean isOnFire() {
            return this.isOnFire;
        }

        @Override
        public void sync(Entity entity) {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), new FirePacket(entity.m_19879_(), this.serializeNBT()));
        }

        @Override
        public void setOnFire() {
            this.isOnFire = true;
            this.sync(this.entity);
        }

        @Override
        public void unsetOnFire() {
            this.isOnFire = false;
            this.sync(this.entity);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("isOnFire", this.isOnFire);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.isOnFire = tag.m_128471_("isOnFire");
        }
    }
}

