/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.util;

import com.legacy.blue_skies.BlueSkies;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;

public class BiomeUtil {
    public static Optional<ResourceKey<Biome>> getOptionalKeyFromBiome(LevelAccessor world, Biome biomeIn) {
        return world.m_5962_().m_175515_(Registry.f_122885_).m_7854_((Object)biomeIn);
    }

    public static ResourceKey<Biome> getKeyFromBiome(LevelAccessor world, Biome biomeIn) {
        Optional<ResourceKey<Biome>> biome = BiomeUtil.getOptionalKeyFromBiome(world, biomeIn);
        if (biome.isPresent()) {
            return biome.get();
        }
        BlueSkies.LOGGER.error("Failed to get the registry key from " + biomeIn + ". This is not good!");
        return null;
    }

    public static Biome getBiomeFromId(int id) {
        return (Biome)BuiltinRegistries.f_123865_.m_7942_(id);
    }

    public static int getBiomeId(Biome biome) {
        return BuiltinRegistries.f_123865_.m_7447_((Object)biome);
    }

    public static int getBiomeId(ResourceKey<Biome> biomeKey) {
        Biome biome = (Biome)BuiltinRegistries.f_123865_.m_6246_(biomeKey);
        if (biome != null) {
            return BuiltinRegistries.f_123865_.m_7447_((Object)biome);
        }
        BlueSkies.LOGGER.error("Could not find a biome with the key: ", (Object)biomeKey.toString());
        return 0;
    }

    public static ResourceKey<Biome> getKeyFromBiomeId(LevelAccessor world, int biomeId) {
        return BiomeUtil.getKeyFromBiome(world, BiomeUtil.getBiomeFromId(biomeId));
    }
}

