/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.util.resloc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class OutOfJarResourceLocation
extends ResourceLocation {
    private final Path nioPath;

    protected OutOfJarResourceLocation(String namespace, Path path, String pathString) {
        super(new String[]{namespace, pathString});
        this.nioPath = path;
    }

    public static OutOfJarResourceLocation of(String namespace, Path path) {
        Path fullPath = path.toAbsolutePath().normalize();
        return new OutOfJarResourceLocation(namespace, fullPath, fullPath.toString().toLowerCase().replace('\\', '/').replaceAll("[^a-z0-9/._-]", "_"));
    }

    public static OutOfJarResourceLocation ofMinecraftFolder(String namespace, String ... parts) {
        Path path = Minecraft.m_91087_().f_91069_.toPath().resolve(namespace);
        for (String part : parts) {
            path = path.resolve(part);
        }
        return OutOfJarResourceLocation.of(namespace, path);
    }

    public Path getNioPath() {
        return this.nioPath;
    }

    public static InputStream openStream(ResourceLocation resLoc, ResourceManager fallbackManager) throws IOException {
        if (resLoc instanceof OutOfJarResourceLocation) {
            OutOfJarResourceLocation nioResLoc = (OutOfJarResourceLocation)resLoc;
            return Files.newInputStream(nioResLoc.nioPath, new OpenOption[0]);
        }
        return fallbackManager.m_215595_(resLoc);
    }

    public static BufferedReader openReader(ResourceLocation resLoc, ResourceManager fallbackManager) throws IOException {
        if (resLoc instanceof OutOfJarResourceLocation) {
            OutOfJarResourceLocation nioResLoc = (OutOfJarResourceLocation)resLoc;
            return Files.newBufferedReader(nioResLoc.nioPath);
        }
        return fallbackManager.m_215597_(resLoc);
    }

    public int compareNamespaced(ResourceLocation o) {
        if (o instanceof OutOfJarResourceLocation) {
            OutOfJarResourceLocation nioResLoc = (OutOfJarResourceLocation)o;
            int ret = this.f_135804_.compareTo(nioResLoc.f_135804_);
            return ret != 0 ? ret : this.nioPath.compareTo(nioResLoc.nioPath);
        }
        return super.compareNamespaced(o);
    }

    public int compareTo(ResourceLocation o) {
        if (o instanceof OutOfJarResourceLocation) {
            OutOfJarResourceLocation nioResLoc = (OutOfJarResourceLocation)o;
            int ret = this.nioPath.compareTo(nioResLoc.nioPath);
            return ret != 0 ? ret : this.f_135804_.compareTo(nioResLoc.f_135804_);
        }
        return super.compareTo(o);
    }

    public int hashCode() {
        return 31 * this.f_135804_.hashCode() + this.nioPath.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OutOfJarResourceLocation) {
            OutOfJarResourceLocation nioResLoc = (OutOfJarResourceLocation)((Object)obj);
            return this.f_135804_.equals(nioResLoc.f_135804_) && this.nioPath.equals(nioResLoc.nioPath);
        }
        return false;
    }
}

