/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui;

import com.ldtteam.blockui.Parsers;
import com.ldtteam.blockui.mod.Log;
import com.ldtteam.blockui.views.View;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PaneParams {
    private final Map<String, Object> propertyCache = new HashMap<String, Object>();
    private final List<PaneParams> children;
    private final Node node;
    private View parentView;

    public PaneParams(Node n) {
        this.node = n;
        this.children = new ArrayList<PaneParams>(this.node.getChildNodes().getLength());
    }

    public String getType() {
        return this.node.getNodeName();
    }

    public View getParentView() {
        return this.parentView;
    }

    public void setParentView(View parent) {
        this.parentView = parent;
    }

    public int getParentWidth() {
        return this.parentView != null ? this.parentView.getInteriorWidth() : 0;
    }

    public int getParentHeight() {
        return this.parentView != null ? this.parentView.getInteriorHeight() : 0;
    }

    public List<PaneParams> getChildren() {
        if (!this.children.isEmpty()) {
            return this.children;
        }
        for (Node child = this.node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            this.children.add(new PaneParams(child));
        }
        return this.children;
    }

    public String getText() {
        return this.node.getTextContent().trim();
    }

    private Node getAttribute(String name) {
        return this.node.getAttributes().getNamedItem(name);
    }

    public boolean hasAttribute(String name) {
        return this.node.getAttributes().getNamedItem(name) != null;
    }

    public <T> T getProperty(String name, Function<String, T> parser, T def) {
        Node attr;
        Object result = null;
        if (this.propertyCache.containsKey(name)) {
            try {
                result = this.propertyCache.get(name);
                return (T)(result != null ? result : def);
            }
            catch (ClassCastException cce) {
                Log.getLogger().warn("Invalid property: previous value of key does not match type.");
            }
        }
        if ((attr = this.getAttribute(name)) != null) {
            result = parser.apply(attr.getNodeValue());
        }
        this.propertyCache.put(name, result);
        return (T)(result != null ? result : def);
    }

    @Nullable
    public String getString(String name) {
        return this.getString(name, null);
    }

    public String getString(String name, String def) {
        return this.getProperty(name, String::toString, def);
    }

    public ResourceLocation getResource(String name, String def) {
        return this.getProperty(name, Parsers.RESOURCE, new ResourceLocation(def));
    }

    @Nullable
    public ResourceLocation getResource(String name, Consumer<ResourceLocation> loader) {
        ResourceLocation rl = this.getResource(name, "");
        if (!rl.m_135815_().isEmpty()) {
            loader.accept(rl);
            return rl;
        }
        return null;
    }

    public List<MutableComponent> getMultilineText(String name) {
        return this.getMultilineText(name, Collections.emptyList());
    }

    public List<MutableComponent> getMultilineText(String name, List<MutableComponent> def) {
        return this.getProperty(name, Parsers.MULTILINE, def);
    }

    public MutableComponent getTextComponent(String name, MutableComponent def) {
        return this.getProperty(name, Parsers.TEXT, def);
    }

    public int getInteger(String name, int def) {
        return this.getProperty(name, Parsers.INT, def);
    }

    public float getFloat(String name, float def) {
        return this.getProperty(name, Parsers.FLOAT, Float.valueOf(def)).floatValue();
    }

    public double getDouble(String name, double def) {
        return this.getProperty(name, Parsers.DOUBLE, def);
    }

    public boolean getBoolean(String name, boolean def) {
        return this.getProperty(name, Parsers.BOOLEAN, def);
    }

    public <T extends Enum<T>> T getEnum(String name, Class<T> clazz, T def) {
        return (T)((Enum)this.getProperty(name, Parsers.ENUM(clazz), def));
    }

    public int getScaledInteger(String name, int scale, int def) {
        return this.getProperty(name, Parsers.SCALED(scale), def);
    }

    public void getScaledInteger(String name, int scaleX, int scaleY, Consumer<List<Integer>> applier) {
        List<Integer> results = Parsers.SCALED(scaleX, scaleY).apply(this.getString(name));
        if (results != null) {
            applier.accept(results);
        }
    }

    public int getColor(String name, int def) {
        return this.getProperty(name, Parsers.COLOR, def);
    }

    public <T> void applyShorthand(String name, Function<String, T> parser, int parts, Consumer<List<T>> applier) {
        List<T> results = Parsers.shorthand(parser, parts).apply(this.getString(name));
        if (results != null) {
            applier.accept(results);
        }
    }

    public String hasAnyAttribute(String def, String ... attributes) {
        NamedNodeMap nodeMap = this.node.getAttributes();
        for (String attr : attributes) {
            if (nodeMap.getNamedItem(attr) == null) continue;
            return attr;
        }
        return def;
    }
}

