/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine.blocks;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.TurbineActivity;
import net.roguelogix.phosphophyllite.modular.block.PhosphophylliteBlock;
import net.roguelogix.phosphophyllite.multiblock.IAssemblyStateBlock;
import net.roguelogix.phosphophyllite.multiblock.rectangular.IRectangularMultiblockBlock;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class TurbineBaseBlock
extends PhosphophylliteBlock
implements IRectangularMultiblockBlock,
EntityBlock {
    public static final BlockBehaviour.Properties PROPERTIES_SOLID = BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_155954_(2.0f).m_155956_(10.0f).m_60922_((a, b, c, d) -> false).m_60999_();
    public static final BlockBehaviour.Properties PROPERTIES_GLASS = BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60955_().m_155954_(2.0f).m_155956_(2.0f).m_60922_((a, b, c, d) -> false).m_60999_();

    public TurbineBaseBlock() {
        this(true);
    }

    public TurbineBaseBlock(boolean solid) {
        super(solid ? PROPERTIES_SOLID : PROPERTIES_GLASS);
        if (this.usesTurbineState()) {
            this.m_49959_((BlockState)this.m_49966_().m_61124_(TurbineActivity.TURBINE_STATE_ENUM_PROPERTY, (Comparable)((Object)TurbineActivity.INACTIVE)));
        }
    }

    public boolean usesTurbineState() {
        return false;
    }

    protected void buildStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.usesTurbineState()) {
            builder.m_61104_(new Property[]{TurbineActivity.TURBINE_STATE_ENUM_PROPERTY});
        }
    }

    public boolean isGoodForInterior() {
        return false;
    }

    public boolean isGoodForExterior() {
        return true;
    }

    public boolean isGoodForFrame() {
        return false;
    }

    public InteractionResult onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (hand == InteractionHand.MAIN_HAND && state.m_61138_((Property)IAssemblyStateBlock.ASSEMBLED) && ((Boolean)state.m_61143_((Property)IAssemblyStateBlock.ASSEMBLED)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)blockEntity;
            if (!level.f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)menuProvider, (BlockPos)pos);
            }
            return InteractionResult.SUCCESS;
        }
        return super.onUse(state, level, pos, player, hand, hitResult);
    }
}

