/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineBaseBlock;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineRotorBlade;
import net.roguelogix.biggerreactors.multiblocks.turbine.blocks.TurbineRotorShaft;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.ITurbineSimulation;
import net.roguelogix.biggerreactors.multiblocks.turbine.simulation.modern.ModernTurbineSimulation;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.TurbineActivity;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.TurbineState;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.VentState;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineBaseTile;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineFluidPortTile;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineGlassTile;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbinePowerTapTile;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineRotorBearingTile;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineRotorBladeTile;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineRotorShaftTile;
import net.roguelogix.biggerreactors.multiblocks.turbine.tiles.TurbineTerminalTile;
import net.roguelogix.biggerreactors.registries.TurbineCoilRegistry;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.debug.DebugInfo;
import net.roguelogix.phosphophyllite.multiblock.ValidationError;
import net.roguelogix.phosphophyllite.multiblock.rectangular.RectangularMultiblockController;
import net.roguelogix.phosphophyllite.repack.org.joml.Matrix4f;
import net.roguelogix.phosphophyllite.repack.org.joml.Matrix4fc;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3f;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3fc;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector4f;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector4i;
import net.roguelogix.phosphophyllite.util.Util;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TurbineMultiblockController
extends RectangularMultiblockController<TurbineBaseTile, TurbineMultiblockController> {
    private int foundShafts = 0;
    private int foundBlades = 0;
    private boolean updateBlockStates = false;
    private final Set<TurbineTerminalTile> terminals = new HashSet<TurbineTerminalTile>();
    private final Set<TurbineFluidPortTile> fluidPorts = new HashSet<TurbineFluidPortTile>();
    private final Set<TurbineRotorBearingTile> rotorBearings = new HashSet<TurbineRotorBearingTile>();
    private final ObjectArrayList<TurbineRotorShaftTile> rotorShafts = new ObjectArrayList();
    private int attachedBladeCount = 0;
    private final Set<TurbinePowerTapTile> powerTaps = new HashSet<TurbinePowerTapTile>();
    private long glassCount = 0L;
    public final ArrayList<Vector4i> rotorConfiguration = new ArrayList();
    public Vec3i rotationAxis = new Vec3i(0, 0, 0);
    private final ITurbineSimulation simulation = TurbineMultiblockController.createSimulation();

    public TurbineMultiblockController(Level world) {
        super(world, tile -> tile instanceof TurbineBaseTile, block -> block instanceof TurbineBaseBlock);
        this.minSize.set(5, 4, 5);
        this.maxSize.set(Config.CONFIG.Turbine.MaxLength, Config.CONFIG.Turbine.MaxHeight, Config.CONFIG.Turbine.MaxWidth);
        this.exteriorValidator = this.frameValidator = block -> false;
        this.interiorValidator = block -> block.m_49966_().m_60795_() || TurbineCoilRegistry.isBlockAllowed(block);
        this.validationStartedCallback = () -> {
            this.foundShafts = 0;
            this.foundBlades = 0;
        };
        this.blockValidatedCallback = block -> {
            if (block == TurbineRotorShaft.INSTANCE) {
                ++this.foundShafts;
            }
            if (block == TurbineRotorBlade.INSTANCE) {
                ++this.foundBlades;
            }
        };
        this.setAssemblyValidator(TurbineMultiblockController::validate);
    }

    private boolean validate() {
        int secondaryAxisPos;
        Direction marchDirection;
        if (this.foundShafts != this.rotorShafts.size()) {
            throw new ValidationError("multiblock.error.biggerreactors.dangling_internal_part");
        }
        if (this.foundBlades != this.attachedBladeCount) {
            throw new ValidationError("multiblock.error.biggerreactors.dangling_internal_part");
        }
        if (this.rotorBearings.size() != 2) {
            throw new ValidationError("multiblock.error.biggerreactors.turbine.rotor_bearing_count");
        }
        Iterator<TurbineRotorBearingTile> iterator = this.rotorBearings.iterator();
        TurbineRotorBearingTile primaryBearing = iterator.next();
        TurbineRotorBearingTile secondaryBearing = iterator.next();
        BlockPos bearingPosition = primaryBearing.m_58899_();
        if (bearingPosition.m_123341_() == this.minCoord().x()) {
            marchDirection = Direction.EAST;
        } else if (bearingPosition.m_123341_() == this.maxCoord().x()) {
            marchDirection = Direction.WEST;
        } else if (bearingPosition.m_123342_() == this.minCoord().y()) {
            marchDirection = Direction.UP;
        } else if (bearingPosition.m_123342_() == this.maxCoord().y()) {
            marchDirection = Direction.DOWN;
        } else if (bearingPosition.m_123343_() == this.minCoord().z()) {
            marchDirection = Direction.SOUTH;
        } else if (bearingPosition.m_123343_() == this.maxCoord().z()) {
            marchDirection = Direction.NORTH;
        } else {
            throw new ValidationError("multiblock.error.biggerreactors.turbine.rotor_bearing_position_undefined");
        }
        int marchedBlocks = 0;
        int x = bearingPosition.m_123341_();
        int y = bearingPosition.m_123342_();
        int z = bearingPosition.m_123343_();
        int marchX = marchDirection.m_122436_().m_123341_();
        int marchY = marchDirection.m_122436_().m_123342_();
        int marchZ = marchDirection.m_122436_().m_123343_();
        --marchedBlocks;
        do {
            ++marchedBlocks;
        } while (this.blocks.getTile(x += marchX, y += marchY, z += marchZ) instanceof TurbineRotorShaftTile);
        if (this.rotorShafts.size() != marchedBlocks) {
            throw new ValidationError("multiblock.error.biggerreactors.turbine.rotor_shaft_off_shaft");
        }
        if (!(this.blocks.getTile(x, y, z) instanceof TurbineRotorBearingTile)) {
            throw new ValidationError("multiblock.error.biggerreactors.turbine.rotor_shaft_bearing_ends");
        }
        marchedBlocks = 0;
        Vec3i[] bladeDirections = new Vec3i[4];
        int i = 0;
        for (Direction value : Direction.values()) {
            if (value == marchDirection || value == marchDirection.m_122424_()) continue;
            bladeDirections[i++] = value.m_122436_();
        }
        for (i = 0; i < this.rotorShafts.size(); ++i) {
            BlockPos rotorShaftPos = ((TurbineRotorShaftTile)((Object)this.rotorShafts.get(i))).m_58899_();
            for (int j = 0; j < 4; ++j) {
                int x2 = rotorShaftPos.m_123341_();
                int y2 = rotorShaftPos.m_123342_();
                int z2 = rotorShaftPos.m_123343_();
                Vec3i bladeDirection = bladeDirections[j];
                int marchX2 = bladeDirection.m_123341_();
                int marchY2 = bladeDirection.m_123342_();
                int marchZ2 = bladeDirection.m_123343_();
                --marchedBlocks;
                do {
                    ++marchedBlocks;
                } while (this.blocks.getTile(x2 += marchX2, y2 += marchY2, z2 += marchZ2) instanceof TurbineRotorBladeTile);
            }
        }
        if (marchedBlocks != this.attachedBladeCount) {
            throw new ValidationError("multiblock.error.biggerreactors.turbine.rotor_blade_off_blade");
        }
        Vector3i sliceMin = new Vector3i(this.minCoord()).add(1, 1, 1);
        Vector3i sliceMax = new Vector3i(this.maxCoord()).sub(1, 1, 1);
        int layerCount = this.rotorShafts.size();
        int[] layerFlags = new int[layerCount];
        int axisComponent = marchDirection.m_122434_().m_7863_(0, 1, 2);
        int axisPosOffset = sliceMin.get(axisComponent);
        Util.chunkCachedBlockStateIteration((Vector3ic)sliceMin, (Vector3ic)sliceMax, (Level)this.world, (state, pos) -> {
            if (state.m_60795_()) {
                return;
            }
            Block block = state.m_60734_();
            if (block == TurbineRotorShaft.INSTANCE) {
                return;
            }
            int axisPos = pos.get(axisComponent);
            int layerIndex = axisPos - axisPosOffset;
            if (block == TurbineRotorBlade.INSTANCE) {
                int n = layerIndex;
                layerFlags[n] = layerFlags[n] | 1;
            } else {
                int n = layerIndex;
                layerFlags[n] = layerFlags[n] | 2;
            }
        });
        boolean inBlades = false;
        boolean bladesLower = false;
        int switches = 0;
        block11: for (int i2 = 0; i2 < layerCount; ++i2) {
            switch (layerFlags[i2]) {
                case 0: {
                    continue block11;
                }
                case 1: {
                    if (!inBlades && switches >= 2) {
                        throw new ValidationError("multiblock.error.biggerreactors.turbine.multiple_groups");
                    }
                    if (!inBlades) {
                        ++switches;
                        bladesLower = true;
                    }
                    inBlades = true;
                    continue block11;
                }
                case 2: {
                    if (inBlades && switches >= 2) {
                        throw new ValidationError("multiblock.error.biggerreactors.turbine.multiple_groups");
                    }
                    if (inBlades) {
                        ++switches;
                        bladesLower = false;
                    }
                    inBlades = false;
                    continue block11;
                }
                case 3: {
                    throw new ValidationError("multiblock.error.biggerreactors.turbine.mixed_blades_and_coil");
                }
            }
        }
        int primaryAxisPos = primaryBearing.m_58899_().m_123304_(marchDirection.m_122434_());
        if (primaryAxisPos < (secondaryAxisPos = secondaryBearing.m_58899_().m_123304_(marchDirection.m_122434_())) ^ bladesLower) {
            primaryBearing.isRenderBearing = true;
            secondaryBearing.isRenderBearing = false;
        } else {
            primaryBearing.isRenderBearing = false;
            secondaryBearing.isRenderBearing = true;
        }
        if (switches <= 1) {
            if (primaryAxisPos > secondaryAxisPos) {
                primaryBearing.isRenderBearing = true;
                secondaryBearing.isRenderBearing = false;
            } else {
                primaryBearing.isRenderBearing = false;
                secondaryBearing.isRenderBearing = true;
            }
        }
        return true;
    }

    protected void onPartPlaced(TurbineBaseTile placed) {
        this.onPartAttached(placed);
    }

    protected void onPartAttached(TurbineBaseTile tile) {
        if (tile instanceof TurbineTerminalTile) {
            this.terminals.add((TurbineTerminalTile)tile);
        }
        if (tile instanceof TurbineFluidPortTile) {
            this.fluidPorts.add((TurbineFluidPortTile)tile);
        }
        if (tile instanceof TurbineRotorBearingTile) {
            this.rotorBearings.add((TurbineRotorBearingTile)tile);
        }
        if (tile instanceof TurbineRotorShaftTile) {
            this.rotorShafts.add((Object)((TurbineRotorShaftTile)tile));
        }
        if (tile instanceof TurbineRotorBladeTile) {
            ++this.attachedBladeCount;
        }
        if (tile instanceof TurbinePowerTapTile) {
            this.powerTaps.add((TurbinePowerTapTile)tile);
        }
        if (tile instanceof TurbineGlassTile) {
            ++this.glassCount;
        }
    }

    protected void onPartBroken(TurbineBaseTile broken) {
        this.onPartDetached(broken);
    }

    protected void onPartDetached(TurbineBaseTile tile) {
        if (tile instanceof TurbineTerminalTile) {
            this.terminals.remove((Object)tile);
        }
        if (tile instanceof TurbineFluidPortTile) {
            this.fluidPorts.remove((Object)tile);
        }
        if (tile instanceof TurbineRotorBearingTile) {
            this.rotorBearings.remove((Object)tile);
        }
        if (tile instanceof TurbineRotorShaftTile) {
            int index = this.rotorShafts.indexOf((Object)tile);
            TurbineRotorShaftTile endFuelRod = (TurbineRotorShaftTile)((Object)this.rotorShafts.pop());
            if (index != this.rotorShafts.size()) {
                this.rotorShafts.set(index, (Object)endFuelRod);
            }
        }
        if (tile instanceof TurbineRotorBladeTile) {
            --this.attachedBladeCount;
        }
        if (tile instanceof TurbinePowerTapTile) {
            this.powerTaps.remove((Object)tile);
        }
        if (tile instanceof TurbineGlassTile) {
            --this.glassCount;
        }
    }

    public void updateBlockStates() {
        this.terminals.forEach(terminal -> {
            this.world.m_46597_(terminal.m_58899_(), (BlockState)terminal.m_58900_().m_61124_(TurbineActivity.TURBINE_STATE_ENUM_PROPERTY, (Comparable)((Object)(this.simulation.active() ? TurbineActivity.ACTIVE : TurbineActivity.INACTIVE))));
            terminal.m_6596_();
        });
    }

    private static ITurbineSimulation createSimulation() {
        return new ModernTurbineSimulation();
    }

    public ITurbineSimulation simulation() {
        return this.simulation;
    }

    protected void onAssembled() {
        this.simulation.reset();
    }

    protected void onValidationPassed() {
        for (TurbinePowerTapTile powerPort : this.powerTaps) {
            powerPort.updateOutputDirection();
        }
        Vector3i internalVolume = new Vector3i().add(this.maxCoord()).sub(this.minCoord()).sub(1, 1, 1);
        BlockPos bearingPos = this.rotorBearings.iterator().next().m_58899_();
        if (bearingPos.m_123341_() == this.minCoord().x() || bearingPos.m_123341_() == this.maxCoord().x()) {
            internalVolume.y ^= internalVolume.x;
            internalVolume.x ^= internalVolume.y;
            internalVolume.y ^= internalVolume.x;
        }
        if (bearingPos.m_123343_() == this.minCoord().z() || bearingPos.m_123343_() == this.maxCoord().z()) {
            internalVolume.y ^= internalVolume.z;
            internalVolume.z ^= internalVolume.y;
            internalVolume.y ^= internalVolume.z;
        }
        this.simulation.resize(internalVolume.x, internalVolume.y, internalVolume.z);
        block1: for (TurbineRotorBearingTile rotorBearing : this.rotorBearings) {
            if (!rotorBearing.isRenderBearing) continue;
            for (Direction value : Direction.values()) {
                BlockPos possibleRotorPos = rotorBearing.m_58899_().m_121945_(value);
                if (this.world.m_8055_(possibleRotorPos).m_60734_() != TurbineRotorShaft.INSTANCE) continue;
                this.rotationAxis = value.m_122436_();
                this.rotorConfiguration.clear();
                Direction.Axis shaftAxis = value.m_122434_();
                BlockPos currentRotorPosition = possibleRotorPos;
                while (this.world.m_8055_(currentRotorPosition).m_60734_() == TurbineRotorShaft.INSTANCE) {
                    Vector4i shaftSectionConfiguration = new Vector4i();
                    int i = 0;
                    for (Direction bladeDirection : Direction.values()) {
                        if (bladeDirection.m_122434_() == shaftAxis) continue;
                        int bladeCount = 0;
                        BlockPos currentBladePosition = currentRotorPosition;
                        currentBladePosition = currentBladePosition.m_121945_(bladeDirection);
                        while (this.world.m_8055_(currentBladePosition).m_60734_() == TurbineRotorBlade.INSTANCE) {
                            ++bladeCount;
                            currentBladePosition = currentBladePosition.m_121945_(bladeDirection);
                        }
                        shaftSectionConfiguration.setComponent(i, bladeCount);
                        ++i;
                    }
                    this.rotorConfiguration.add(shaftSectionConfiguration);
                    currentRotorPosition = currentRotorPosition.m_121945_(value);
                }
                continue block1;
            }
        }
        this.simulation.setRotorConfiguration(this.rotorConfiguration);
        if (this.glassCount <= 0L) {
            for (TurbineRotorBearingTile rotorBearing : this.rotorBearings) {
                rotorBearing.isRenderBearing = false;
            }
        }
        Matrix4f blockToRotorRelativePos = new Matrix4f();
        if (this.rotationAxis.m_123342_() == -1) {
            blockToRotorRelativePos.rotate((float)Math.PI, 0.0f, 0.0f, 1.0f);
        } else {
            Vector3f cross = new Vector3f();
            cross.set((float)this.rotationAxis.m_123341_(), (float)this.rotationAxis.m_123342_(), (float)this.rotationAxis.m_123343_());
            cross.cross(0.0f, 1.0f, 0.0f);
            cross.normalize();
            blockToRotorRelativePos.rotate(1.5707964f, (Vector3fc)cross);
        }
        blockToRotorRelativePos.translate((float)(-bearingPos.m_123341_()), (float)(-bearingPos.m_123342_()), (float)(-bearingPos.m_123343_()));
        Vector4f translationPos = new Vector4f();
        Util.chunkCachedBlockStateIteration((Vector3ic)new Vector3i(1).add(this.minCoord()), (Vector3ic)new Vector3i(-1).add(this.maxCoord()), (Level)this.world, (blockState, pos) -> {
            Block block = blockState.m_60734_();
            if (block instanceof AirBlock) {
                return;
            }
            TurbineCoilRegistry.CoilData coilData = TurbineCoilRegistry.getCoilData(block);
            if (coilData != null) {
                translationPos.set((Vector3ic)pos, 1.0f);
                translationPos.mul((Matrix4fc)blockToRotorRelativePos);
                this.simulation.setCoilData((int)translationPos.x, (int)translationPos.z, coilData);
            }
        });
        this.simulation.updateInternalValues();
    }

    protected void onDisassembled() {
        for (TurbineRotorBearingTile rotorBearing : this.rotorBearings) {
            this.world.m_7260_(rotorBearing.m_58899_(), rotorBearing.m_58900_(), rotorBearing.m_58900_(), 0);
        }
    }

    public void tick() {
        if (this.updateBlockStates) {
            this.updateBlockStates = false;
            this.updateBlockStates();
        }
        this.simulation.tick();
        long totalPowerRequested = 0L;
        long stored = this.simulation.battery().stored();
        for (TurbinePowerTapTile powerPort : this.powerTaps) {
            long requested = powerPort.distributePower(stored, true);
            if (requested > stored) continue;
            totalPowerRequested += requested;
        }
        long startingPower = this.simulation.battery().stored();
        double distributionMultiplier = Math.min(1.0, (double)startingPower / (double)totalPowerRequested);
        for (TurbinePowerTapTile powerPort : this.powerTaps) {
            long powerRequested = powerPort.distributePower(startingPower, true);
            if (powerRequested > startingPower) continue;
            powerRequested = (long)((double)powerRequested * distributionMultiplier);
            powerRequested = Math.min(this.simulation.battery().stored(), powerRequested);
            this.simulation.battery().extract(powerPort.distributePower(powerRequested, false));
        }
        for (TurbineFluidPortTile coolantPort : this.fluidPorts) {
            if (this.simulation.fluidTank().liquidAmount() < 0L) break;
            coolantPort.pushFluid();
        }
        if (Phosphophyllite.tickNumber() % 10L == 0L) {
            for (TurbineRotorBearingTile rotorBearing : this.rotorBearings) {
                this.world.m_7260_(rotorBearing.m_58899_(), rotorBearing.m_58900_(), rotorBearing.m_58900_(), 0);
            }
        }
        if (Phosphophyllite.tickNumber() % 2L == 0L) {
            this.markDirty();
        }
    }

    public void updateDataPacket(TurbineState turbineState) {
        turbineState.turbineActivity = this.simulation.active() ? TurbineActivity.ACTIVE : TurbineActivity.INACTIVE;
        turbineState.ventState = this.simulation.ventState();
        turbineState.coilStatus = this.simulation.coilEngaged();
        turbineState.flowRate = this.simulation.nominalFlowRate();
        turbineState.efficiencyRate = this.simulation.bladeEfficiencyLastTick();
        turbineState.turbineOutputRate = this.simulation.FEGeneratedLastTick();
        turbineState.currentRPM = this.simulation.RPM();
        turbineState.maxRPM = 2200.0;
        turbineState.intakeStored = this.simulation.fluidTank().vaporAmount();
        turbineState.intakeCapacity = this.simulation.fluidTank().perSideCapacity();
        turbineState.intakeResourceLocation = ForgeRegistries.FLUIDS.getKey((Object)this.simulation().fluidTank().vaporType()).toString();
        turbineState.exhaustStored = this.simulation.fluidTank().liquidAmount();
        turbineState.exhaustCapacity = this.simulation.fluidTank().perSideCapacity();
        turbineState.exhaustResourceLocation = ForgeRegistries.FLUIDS.getKey((Object)this.simulation().fluidTank().liquidType()).toString();
        turbineState.energyStored = this.simulation.battery().stored();
        turbineState.energyCapacity = this.simulation.battery().capacity();
    }

    public void runRequest(String requestName, @Nullable Object requestData) {
        switch (requestName) {
            case "setActive": {
                if (!(requestData instanceof Integer)) {
                    return;
                }
                this.setActive(TurbineActivity.fromInt((Integer)requestData) == TurbineActivity.ACTIVE);
                return;
            }
            case "changeFlowRate": {
                if (!(requestData instanceof Long)) {
                    return;
                }
                this.simulation.setNominalFlowRate(this.simulation.nominalFlowRate() + (Long)requestData);
                return;
            }
            case "setCoilEngaged": {
                if (!(requestData instanceof Integer)) {
                    return;
                }
                this.setCoilEngaged((Integer)requestData != 0);
                return;
            }
            case "setVentState": {
                if (!(requestData instanceof Integer)) {
                    return;
                }
                this.setVentState(VentState.fromInt((Integer)requestData));
                return;
            }
        }
    }

    private void setVentState(VentState newVentState) {
        this.simulation.setVentState(newVentState);
    }

    private void setMaxFlowRate(long flowRate) {
        if (flowRate < 0L) {
            flowRate = 0L;
        }
        if (flowRate > this.simulation.flowRateLimit()) {
            flowRate = this.simulation.flowRateLimit();
        }
        this.simulation.setNominalFlowRate(flowRate);
    }

    private void setCoilEngaged(boolean engaged) {
        this.simulation.setCoilEngaged(engaged);
    }

    @Nonnull
    protected CompoundTag write() {
        return (CompoundTag)this.simulation().serializeNBT();
    }

    protected void read(CompoundTag compound) {
        this.simulation.deserializeNBT((Tag)compound);
        this.updateBlockStates = true;
    }

    public void toggleActive() {
        this.setActive(!this.simulation.active());
    }

    public void setActive(boolean active) {
        if (this.simulation.active() != active) {
            this.simulation.setActive(active);
            this.updateBlockStates = true;
        }
    }

    @Nonnull
    public DebugInfo getDebugInfo() {
        return super.getDebugInfo().add(this.simulation.debugString());
    }
}

