/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.machine.client;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.roguelogix.biggerreactors.client.CommonRender;
import net.roguelogix.biggerreactors.machine.containers.CyaniteReprocessorContainer;
import net.roguelogix.biggerreactors.machine.state.CyaniteReprocessorState;
import net.roguelogix.phosphophyllite.client.gui.RenderHelper;
import net.roguelogix.phosphophyllite.client.gui.elements.AbstractElement;
import net.roguelogix.phosphophyllite.client.gui.elements.RenderedElement;
import net.roguelogix.phosphophyllite.client.gui.elements.TooltipElement;
import net.roguelogix.phosphophyllite.client.gui.screens.PhosphophylliteScreen;

public class CyaniteReprocessorScreen
extends PhosphophylliteScreen<CyaniteReprocessorContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/cyanite_reprocessor.png");
    private CyaniteReprocessorState cyaniteReprocessorState = (CyaniteReprocessorState)((CyaniteReprocessorContainer)this.m_6262_()).getGuiPacket();

    public CyaniteReprocessorScreen(CyaniteReprocessorContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title, DEFAULT_TEXTURE, 176, 175);
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97728_ = this.getXSize() / 2 - this.getFont().m_92852_((FormattedText)this.m_96636_()) / 2;
        this.initTooltips();
        this.initGauges();
        this.initSymbols();
    }

    public void initTooltips() {
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 8, 6, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.cyanite_reprocessor.internal_battery.tooltip")));
    }

    public void initGauges() {
        RenderedElement internalBattery = new RenderedElement((PhosphophylliteScreen)this, 7, 25, 18, 64, 0, 152, (Component)Component.m_237119_());
        internalBattery.onRender = (mS, mX, mY) -> CommonRender.renderEnergyGauge(mS, internalBattery, this.cyaniteReprocessorState.energyStored, this.cyaniteReprocessorState.energyCapacity);
        this.addScreenElement((AbstractElement)internalBattery);
        RenderedElement waterTank = new RenderedElement((PhosphophylliteScreen)this, 151, 25, 18, 64, 0, 152, (Component)Component.m_237119_());
        waterTank.onRender = (mS, mX, mY) -> CommonRender.renderFluidGauge(mS, waterTank, this.cyaniteReprocessorState.waterStored, this.cyaniteReprocessorState.waterCapacity, Fluids.f_76193_.m_5613_());
        this.addScreenElement((AbstractElement)waterTank);
        RenderedElement progressBar = new RenderedElement((PhosphophylliteScreen)this, 75, 40, 24, 18, 0, 175, null);
        progressBar.onRender = (mS, mX, mY) -> CyaniteReprocessorScreen.renderProgressBar(mS, (RenderedElement<CyaniteReprocessorContainer>)progressBar, this.cyaniteReprocessorState.workTime, this.cyaniteReprocessorState.workTimeTotal);
        this.addScreenElement((AbstractElement)progressBar);
    }

    public void initSymbols() {
        RenderedElement waterTankSymbol = new RenderedElement((PhosphophylliteScreen)this, 152, 6, 16, 16, 48, 175, (Component)Component.m_237115_((String)"screen.biggerreactors.cyanite_reprocessor.water_tank.tooltip"));
        waterTankSymbol.onRender = (mS, mX, mY) -> RenderHelper.drawMaskedFluid((PoseStack)mS, (int)waterTankSymbol.x, (int)waterTankSymbol.y, (int)this.m_93252_(), (int)waterTankSymbol.width, (int)waterTankSymbol.height, (int)waterTankSymbol.u, (int)waterTankSymbol.v, (Fluid)Fluids.f_76193_.m_5613_());
        this.addScreenElement((AbstractElement)waterTankSymbol);
    }

    private static void renderProgressBar(@Nonnull PoseStack poseStack, @Nonnull RenderedElement<CyaniteReprocessorContainer> symbol, int workTime, int workTimeTotal) {
        if (workTime > 0 && workTimeTotal > 0) {
            int renderSize = symbol.width * workTime / workTimeTotal;
            symbol.blit(poseStack, renderSize, symbol.height, symbol.u + 24, symbol.v);
        }
    }
}

