/*
 * Decompiled with CFR 0.152.
 */
package com.vyklade.ars_armiger.ars_nouveau;

import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.BasicReductionCaster;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.vyklade.ars_armiger.tetra.TetraEventHandler;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ModularItem;

@Mod.EventBusSubscriber(modid="ars_armiger")
public class ArsIntegrations {
    @SubscribeEvent
    public static void onTooltip(@NotNull ItemTooltipEvent event) {
        ItemStack item = event.getItemStack();
        if (!(item.m_41720_() instanceof ModularItem)) {
            return;
        }
        List tooltip = event.getToolTip();
        int spellstriker = ((ModularItem)item.m_41720_()).getEffectLevel(item, ItemEffect.get((String)"spellstrike"));
        int sourceLeecch = ((ModularItem)item.m_41720_()).getEffectLevel(item, ItemEffect.get((String)"source_leech"));
        int spellguard = ((ModularItem)item.m_41720_()).getEffectLevel(item, ItemEffect.get((String)"spellguard"));
        if (sourceLeecch > 0) {
            MutableComponent leech = Component.m_237110_((String)"tetra.tooltips.leech", (Object[])new Object[]{sourceLeecch});
            tooltip.add(leech);
        }
        if ((spellstriker > 0 || spellguard > 0) && item.m_41782_()) {
            MutableComponent inscribeable = Component.m_237115_((String)"tetra.tooltips.inscribable");
            if (item.m_41783_().m_128441_("ars_nouveau:caster")) {
                int power = ((ModularItem)item.m_41720_()).getEffectLevel(item, ItemEffect.get((String)"spellstrike_power"));
                BasicReductionCaster caster = new BasicReductionCaster(item, spell -> {
                    spell.addDiscount(MethodTouch.INSTANCE.getCastingCost());
                    return spell;
                });
                Spell spell2 = caster.getSpell();
                int air = ((ModularItem)item.m_41720_()).getEffectLevel(item, ItemEffect.get((String)"air_attunement"));
                int earth = ((ModularItem)item.m_41720_()).getEffectLevel(item, ItemEffect.get((String)"earth_attunement"));
                int fire = ((ModularItem)item.m_41720_()).getEffectLevel(item, ItemEffect.get((String)"fire_attunement"));
                int water = ((ModularItem)item.m_41720_()).getEffectLevel(item, ItemEffect.get((String)"water_attunement"));
                if (air > 0) {
                    TetraEventHandler.Amplify(spell2, SpellSchools.ELEMENTAL_AIR, air >= 2);
                } else if (earth > 0) {
                    TetraEventHandler.Amplify(spell2, SpellSchools.ELEMENTAL_EARTH, earth >= 2);
                } else if (fire > 0) {
                    TetraEventHandler.Amplify(spell2, SpellSchools.ELEMENTAL_FIRE, fire >= 2);
                } else if (water > 0) {
                    TetraEventHandler.Amplify(spell2, SpellSchools.ELEMENTAL_WATER, water >= 2);
                }
                if (power > 0) {
                    TetraEventHandler.Power(spell2, power);
                }
                if (spell2.isEmpty()) {
                    tooltip.add(inscribeable);
                } else {
                    tooltip.add(Component.m_237113_((String)spell2.getDisplayString()));
                }
            } else {
                tooltip.add(inscribeable);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack item = event.getItemStack();
        Player player = event.getEntity();
        if (item == ItemStack.f_41583_ || player == null) {
            return;
        }
        if (!item.m_41782_()) {
            return;
        }
        if (!item.m_41783_().m_128441_("ars_nouveau:caster")) {
            return;
        }
        if (!player.m_6047_()) {
            return;
        }
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        if (level.m_46859_(event.getPos())) {
            return;
        }
        BlockEntity block = level.m_7702_(event.getPos());
        if (block == null) {
            return;
        }
        if (!(block instanceof ScribesTile)) {
            return;
        }
        ScribesTile table = (ScribesTile)block;
        if (table.getStack() == ItemStack.f_41583_) {
            return;
        }
        ItemStack tableItem = table.getStack();
        if (!(tableItem.m_41720_() instanceof ModularItem)) {
            return;
        }
        int spellstrike = ((ModularItem)tableItem.m_41720_()).getEffectLevel(tableItem, ItemEffect.get((String)"spellstrike"));
        int spellguard = ((ModularItem)tableItem.m_41720_()).getEffectLevel(tableItem, ItemEffect.get((String)"spellguard"));
        if (spellstrike == 0 && spellguard == 0) {
            return;
        }
        ISpellCaster caster = CasterUtil.getCaster((ItemStack)item);
        Spell spell = caster.getSpell();
        SpellCaster itemCaster = new SpellCaster(tableItem);
        if (spell.isEmpty()) {
            itemCaster.setSpell(spell);
            PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.m_237115_((String)"ars_armiger.spellstrike.cleared"));
            event.setCanceled(true);
            return;
        }
        List parts = spell.recipe;
        if (parts.get(0) instanceof AbstractCastMethod) {
            PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.m_237115_((String)"ars_armiger.spellstrike.invalid"));
            event.setCanceled(true);
            return;
        }
        parts.add(0, MethodTouch.INSTANCE);
        spell.recipe = parts;
        itemCaster.setColor(caster.getColor());
        itemCaster.setFlavorText(caster.getFlavorText());
        itemCaster.setSpellName(caster.getSpellName());
        itemCaster.setSound(caster.getCurrentSound());
        itemCaster.setSpell(spell);
        PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.set_spell"));
        event.setCanceled(true);
    }
}

