/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectAnimate;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBlink;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBreak;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectBurst;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectConjureWater;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDelay;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDispel;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectExplosion;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFangs;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFirework;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFreeze;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGlide;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHarm;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHeal;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectHex;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIgnite;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIntangible;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectKnockback;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLaunch;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLeap;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLight;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLightning;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLinger;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectName;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPhantomBlock;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPull;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectRune;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSlowfall;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSnare;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonDecoy;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSummonVex;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWall;
import com.hollingsworth.arsnouveau.common.spell.method.MethodOrbit;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodSelf;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.spell.method.MethodUnderfoot;
import com.hollingsworth.arsnouveau.common.tomes.CasterTomeData;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.SoundRegistry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;

public class CasterTomeProvider
implements DataProvider {
    public final DataGenerator generator;
    public List<CasterTomeData> tomes = new ArrayList<CasterTomeData>();

    public CasterTomeProvider(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        this.tomes.add(this.buildTome("glow", "Glow Trap", new Spell().add((AbstractSpellPart)MethodTouch.INSTANCE).add((AbstractSpellPart)EffectRune.INSTANCE).add((AbstractSpellPart)EffectSnare.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE).add((AbstractSpellPart)EffectLight.INSTANCE), "Snares the target and grants other targets Glowing."));
        this.tomes.add(this.buildTome("bailey", "Bailey's Bovine Rocket", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectExplosion.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE), "To the MOOn"));
        this.tomes.add(this.buildTome("arachne", "Arachne's Weaving", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)AugmentSplit.INSTANCE, 2).add((AbstractSpellPart)EffectSnare.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE), "Creates three snaring projectiles."));
        this.tomes.add(this.buildTome("warp_impact", "Warp Impact", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectBlink.INSTANCE).add((AbstractSpellPart)EffectExplosion.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE), "Teleportation, with style!"));
        this.tomes.add(this.buildTome("farfalla", "Farfalla's Frosty Flames", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectIgnite.INSTANCE).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectConjureWater.INSTANCE).add((AbstractSpellPart)EffectFreeze.INSTANCE), "Creates a fire that quickly freezes to ice."));
        this.tomes.add(this.buildTome("gootastic", "Gootastic's Telekinetic Fishing Rod", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectPull.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2), "The squid's Lovecraftian roots appear to make it immune."));
        this.tomes.add(this.buildTome("toxin", "Potent Toxin", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectHex.INSTANCE).add((AbstractSpellPart)EffectHarm.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE), "Poisons that target and causes them to take additional damage from all sources."));
        this.tomes.add(this.buildTome("shadow", "The Shadow's Temporary Tunnel", new Spell().add((AbstractSpellPart)MethodTouch.INSTANCE).add((AbstractSpellPart)EffectIntangible.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE, 2).add((AbstractSpellPart)AugmentPierce.INSTANCE, 5).add((AbstractSpellPart)AugmentExtendTime.INSTANCE), "Creates a temporary tunnel of blocks."));
        this.tomes.add(this.buildTome("vault", "Vault", new Spell().add((AbstractSpellPart)MethodSelf.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectLeap.INSTANCE).add((AbstractSpellPart)EffectSlowfall.INSTANCE), "Sometimes you just need to get over that wall."));
        this.tomes.add(this.buildTome("fireball", "Fireball!", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectIgnite.INSTANCE).add((AbstractSpellPart)EffectExplosion.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)AugmentAOE.INSTANCE, 2), "A classic."));
        this.tomes.add(this.buildTome("renew_rune", "Rune of Renewing", new Spell().add((AbstractSpellPart)MethodTouch.INSTANCE).add((AbstractSpellPart)EffectRune.INSTANCE).add((AbstractSpellPart)EffectDispel.INSTANCE).add((AbstractSpellPart)EffectHeal.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE), "Cures status effects and heals the user."));
        this.tomes.add(this.buildTome("yeet", "Knocked out of Orbit", new Spell().add((AbstractSpellPart)MethodOrbit.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectKnockback.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2), "Summons orbiting projectiles that will launch nearby enemies."));
        this.tomes.add(this.buildTome("takeoff", "Takeoff!", new Spell().add((AbstractSpellPart)MethodSelf.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE, 2).add((AbstractSpellPart)EffectGlide.INSTANCE).add((AbstractSpellPart)AugmentDurationDown.INSTANCE), "Launches the caster into the air and grants temporary elytra flight!"));
        this.tomes.add(this.buildTome("kirin", "KirinDave's Sinister Switch", new Spell().add((AbstractSpellPart)MethodSelf.INSTANCE).add((AbstractSpellPart)EffectSummonDecoy.INSTANCE).add((AbstractSpellPart)EffectBlink.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE), "Heroes are so straightforward, so easily befuddled...", new ParticleColor(25, 255, 255)));
        this.tomes.add(this.buildTome("xacris", "Xacris' Tiny Hut", new Spell().add((AbstractSpellPart)MethodUnderfoot.INSTANCE).add((AbstractSpellPart)EffectPhantomBlock.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE, 3).add((AbstractSpellPart)AugmentPierce.INSTANCE, 3), "Builds a small hut around the user."));
        this.tomes.add(this.buildTome("xacris_2", "Xacris's Firework Display", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectWall.INSTANCE).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE).add((AbstractSpellPart)EffectFirework.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE, 4).add((AbstractSpellPart)AugmentAmplify.INSTANCE), "Light up the sky", new ParticleColor(25, 255, 255)));
        this.tomes.add(this.buildTome("othy", "Othy's Death By 100 Pricks", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)AugmentPierce.INSTANCE, 2).add((AbstractSpellPart)EffectLinger.INSTANCE).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)EffectSummonVex.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE), "Swarm your enemies with bladed spirits.", new ParticleColor(255, 255, 255)));
        this.tomes.add(this.buildTome("aurellia", "Aurellia's Bite Storm", new Spell().add((AbstractSpellPart)MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectLinger.INSTANCE).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)EffectFangs.INSTANCE).add((AbstractSpellPart)EffectLightning.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)AugmentExtendTime.INSTANCE, 3).withSound(new ConfiguredSpellSound(SoundRegistry.TEMPESTRY_SPELL_SOUND)), "The bite from this storm is worse than its bark.", new ParticleColor(255, 119, 203)));
        this.tomes.add(this.buildTome("alex", "Alex's Magnificent Mansion", new Spell(MethodSelf.INSTANCE).add((AbstractSpellPart)EffectBurst.INSTANCE).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)AugmentDampen.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE, 5).add((AbstractSpellPart)EffectPhantomBlock.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE).add((AbstractSpellPart)AugmentPierce.INSTANCE).withSound(new ConfiguredSpellSound(SoundRegistry.TEMPESTRY_SPELL_SOUND)), "For those who can't settle with just a tiny hut.", new ParticleColor(255, 255, 255)));
        this.tomes.add(this.buildTome("poseidon", "Poseidon's Refuge", new Spell(MethodProjectile.INSTANCE).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)EffectLight.INSTANCE).add((AbstractSpellPart)EffectBurst.INSTANCE).add((AbstractSpellPart)AugmentAOE.INSTANCE, 2).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)EffectFreeze.INSTANCE).add((AbstractSpellPart)EffectBreak.INSTANCE).add((AbstractSpellPart)EffectFreeze.INSTANCE).withSound(new ConfiguredSpellSound(SoundRegistry.TEMPESTRY_SPELL_SOUND)), "Fire at a body of water to create a Ice bubble in the depths.", new ParticleColor(0, 0, 255)));
        this.tomes.add(this.buildTome("chems", "Chem's Scientific Repulsion Runes", new Spell(MethodProjectile.INSTANCE).add((AbstractSpellPart)EffectLinger.INSTANCE).add((AbstractSpellPart)AugmentSensitive.INSTANCE).add((AbstractSpellPart)EffectRune.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE, 4), "Smothers an area with runes that launch entities upward. Do NOT get covered in the Repulsion Runes.", new ParticleColor(61, 207, 248)));
        this.tomes.add(this.buildTome("ivy", "Ivy", new Spell(MethodTouch.INSTANCE).add((AbstractSpellPart)EffectAnimate.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE, 7).add((AbstractSpellPart)EffectName.INSTANCE), "Now you never have to be lonely again! You will always have a friend with you! Feel free to change their name to whatever you want! :D", new ParticleColor(255, 105, 180)));
        Path output = this.generator.m_123916_();
        for (CasterTomeData g : this.tomes) {
            Path path = this.getRecipePath(output, g.m_6423_().m_135815_());
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)g.toJson(), (Path)path);
        }
    }

    protected Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_nouveau/recipes/tomes/" + str + ".json");
    }

    public CasterTomeData buildTome(String id, String name, Spell spell, String flavorText) {
        return new CasterTomeData(new ResourceLocation("ars_nouveau", id + "_tome"), name, spell.serializeRecipe(), ItemsRegistry.CASTER_TOME.registryObject.getId(), flavorText, spell.color.getColor(), spell.sound);
    }

    public CasterTomeData buildTome(String id, String name, Spell spell, String flavorText, ParticleColor color) {
        CasterTomeData data = this.buildTome(id, name, spell, flavorText);
        data.particleColor = color.getColor();
        return data;
    }

    public String m_6055_() {
        return "Ars Nouveau Caster Tomes Datagen";
    }
}

