/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.items;

import alexthw.ars_elemental.common.CurioHolderContainer;
import alexthw.ars_elemental.registry.ModRegistry;
import alexthw.ars_elemental.util.ItemInventory;
import com.hollingsworth.arsnouveau.api.item.AbstractSummonCharm;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.common.items.PotionFlask;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CurioHolder
extends Item {
    public CurioHolder(Item.Properties pProperties) {
        super(pProperties);
    }

    public static ItemStack isEquipped(Player playerEntity) {
        if (playerEntity != null) {
            int i;
            Optional curios = CuriosUtil.getAllWornItems((LivingEntity)playerEntity).resolve();
            if (curios.isPresent()) {
                IItemHandlerModifiable items = (IItemHandlerModifiable)curios.get();
                for (i = 0; i < items.getSlots(); ++i) {
                    ItemStack item = items.getStackInSlot(i);
                    if (!(item.m_41720_() instanceof CurioHolder)) continue;
                    return item;
                }
            }
            Inventory inv = playerEntity.m_150109_();
            for (i = 0; i < 9; ++i) {
                ItemStack stack = (ItemStack)inv.f_35974_.get((inv.f_35977_ + i) % 9);
                if (!(stack.m_41720_() instanceof CurioHolder)) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    public static boolean canStore(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof CurioHolder) {
            return false;
        }
        return item instanceof ItemScroll || item instanceof AbstractSummonCharm || stack.m_204117_(ModRegistry.CURIO_BAGGABLE) || item instanceof ICurioItem || item instanceof PotionFlask;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new InventoryCapability(stack);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        if (!level.f_46443_) {
            ItemStack stack = playerIn.m_21120_(handIn);
            this.openContainer(level, playerIn, stack);
        }
        return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
    }

    public void openContainer(Level level, Player player, ItemStack bag) {
        if (!level.f_46443_) {
            SimpleMenuProvider container = new SimpleMenuProvider((w, p, pl) -> new CurioHolderContainer(w, p, bag), bag.m_41786_());
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)container, b -> b.m_130055_(bag));
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_184215_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static ItemInventory getInventory(ItemStack stack) {
        return new ItemInventory(stack, 27);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    private static class InventoryCapability
    implements ICapabilityProvider {
        private final LazyOptional<IItemHandler> opt = LazyOptional.of(() -> new InvWrapper((Container)CurioHolder.getInventory(stack)));

        public InventoryCapability(ItemStack stack) {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            return ForgeCapabilities.ITEM_HANDLER.orEmpty(capability, this.opt);
        }
    }
}

