/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.common.items.foci.NecroticFocus;
import alexthw.ars_elemental.mixin.FoxInvoker;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.util.EntityCarryMEI;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectCharm
extends ElementalAbstractEffect
implements IPotionEffect {
    public static EffectCharm INSTANCE = new EffectCharm();

    public EffectCharm() {
        super("charm", "Charm");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            if (world instanceof ServerLevel) {
                Mob mob;
                ServerLevel level = (ServerLevel)world;
                Entity entity = rayTraceResult.m_82443_();
                if (entity instanceof Mob && ((mob = (Mob)entity).m_21233_() < (float)((Integer)this.GENERIC_INT.get()).intValue() || player.m_20148_().equals(ArsElemental.Dev))) {
                    Animal a;
                    if (mob instanceof Enemy || mob instanceof NeutralMob && (!(mob instanceof Animal) || !(a = (Animal)mob).m_5957_())) {
                        float resistance = 10.0f + 100.0f * (mob.m_21223_() / mob.m_21233_());
                        double chanceBoost = 10.0 + spellStats.getAmpMultiplier() * 5.0;
                        if (mob.m_6336_() == MobType.f_21641_ && NecroticFocus.hasFocus(world, (Entity)shooter)) {
                            chanceBoost += 50.0;
                        }
                        if (this.rollToSeduce((int)resistance, chanceBoost, level.m_213780_())) {
                            this.applyPotion((LivingEntity)mob, (LivingEntity)player, (MobEffect)ModPotions.ENTHRALLED.get(), spellStats);
                            this.playHeartParticles((LivingEntity)mob, level);
                        }
                    } else {
                        Entity resistance = rayTraceResult.m_82443_();
                        if (resistance instanceof Animal) {
                            Fox fox;
                            AbstractHorse horse;
                            TamableAnimal tamable;
                            Animal animal = (Animal)resistance;
                            if (animal instanceof TamableAnimal && !(tamable = (TamableAnimal)animal).m_21824_()) {
                                if (this.rollToSeduce(100, 25.0 * (1.0 + spellStats.getAmpMultiplier()), level.m_213780_())) {
                                    tamable.m_21828_(player);
                                }
                            } else if (animal instanceof AbstractHorse && !(horse = (AbstractHorse)animal).m_30614_()) {
                                if (this.rollToSeduce(100, 25.0 * (1.0 + spellStats.getAmpMultiplier()), level.m_213780_())) {
                                    horse.m_30651_(true);
                                }
                            } else if (animal instanceof Fox && !((FoxInvoker)(fox = (Fox)animal)).callTrusts(player.m_20148_())) {
                                if (this.rollToSeduce(100, 25.0 * (1.0 + spellStats.getAmpMultiplier()), level.m_213780_())) {
                                    ((FoxInvoker)fox).callAddTrustedUUID(player.m_20148_());
                                }
                            } else if (animal.m_5957_() && this.rollToSeduce(90, 25.0 * (1.0 + spellStats.getAmpMultiplier()), level.m_213780_())) {
                                animal.m_27595_(player);
                            }
                        }
                    }
                }
            }
        }
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    private boolean rollToSeduce(int resistance, double chanceBoost, RandomSource rand) {
        return (double)rand.m_216339_(0, resistance) + chanceBoost >= (double)resistance;
    }

    public int getDefaultManaCost() {
        return 30;
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDefaultPotionConfig(builder);
        this.addGenericInt(builder, 150, "Set the max hp limit for Charm, mobs with more max hp will be immune.", "charm_hp_limit");
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.getPotionAugments();
    }

    public void applyPotion(LivingEntity entity, LivingEntity owner, MobEffect potionEffect, SpellStats stats) {
        if (entity == null || owner == null) {
            return;
        }
        int ticks = this.getBaseDuration() * 20 + this.getExtendTimeDuration() * stats.getDurationInTicks();
        int amp = (int)stats.getAmpMultiplier();
        entity.m_7292_((MobEffectInstance)new EntityCarryMEI(potionEffect, ticks, amp, false, true, owner, null));
    }

    private void playHeartParticles(LivingEntity entity, ServerLevel world) {
        for (int i = 0; i < 5; ++i) {
            double d0 = entity.m_217043_().m_188583_() * 0.02;
            double d1 = entity.m_217043_().m_188583_() * 0.02;
            double d2 = entity.m_217043_().m_188583_() * 0.02;
            world.m_8767_((ParticleOptions)ParticleTypes.f_123750_, entity.m_20185_() + ((double)world.f_46441_.m_188501_() - 0.5) / 2.0, entity.m_20186_() + ((double)world.f_46441_.m_188501_() + 0.5), entity.m_20189_() + ((double)world.f_46441_.m_188501_() - 0.5) / 2.0, 2, d0, d1, d2, (double)0.1f);
        }
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get();
    }
}

