/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        Pair specClientPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specClientPair.getRight();
        CLIENT = (Client)specClientPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Double> MajorFocusDiscount;
        public final ForgeConfigSpec.ConfigValue<Double> LesserFocusDiscount;
        public final ForgeConfigSpec.ConfigValue<Double> FireMasteryBuff;
        public final ForgeConfigSpec.ConfigValue<Double> WaterMasteryBuff;
        public final ForgeConfigSpec.ConfigValue<Double> AirMasteryBuff;
        public final ForgeConfigSpec.ConfigValue<Double> EarthMasteryBuff;
        public final ForgeConfigSpec.ConfigValue<Double> FireMasteryDebuff;
        public final ForgeConfigSpec.ConfigValue<Double> WaterMasteryDebuff;
        public final ForgeConfigSpec.ConfigValue<Double> AirMasteryDebuff;
        public final ForgeConfigSpec.ConfigValue<Double> EarthMasteryDebuff;
        public final ForgeConfigSpec.ConfigValue<Boolean> EnableGlyphEmpowering;
        public final ForgeConfigSpec.ConfigValue<Boolean> EnableRegenBonus;
        public static ForgeConfigSpec.IntValue ARMOR_MAX_MANA;
        public static ForgeConfigSpec.IntValue ARMOR_MANA_REGEN;
        public static ForgeConfigSpec.BooleanValue HOMING_GLOWING;
        public static ForgeConfigSpec.BooleanValue FIRENANDO_KILL;
        public static ForgeConfigSpec.IntValue SIREN_MANA_COST;
        public static ForgeConfigSpec.IntValue SIREN_MAX_PROGRESS;
        public static ForgeConfigSpec.IntValue SIREN_BASE_ITEM;
        public static ForgeConfigSpec.IntValue SIREN_UNIQUE_BONUS;
        public static ForgeConfigSpec.DoubleValue SIREN_TREASURE_BONUS;
        public static ForgeConfigSpec.IntValue SIREN_QUANTITY_CAP;
        public static ForgeConfigSpec.IntValue WATER_URN_COST;
        public static ForgeConfigSpec.IntValue AIR_ELEVATOR_COST;
        public static ForgeConfigSpec.IntValue LAVA_ELEVATOR_COST;
        public static ForgeConfigSpec.IntValue WATER_ELEVATOR_COST;
        public static ForgeConfigSpec.BooleanValue LIGHTNINGS_BIOME;
        public static ForgeConfigSpec.BooleanValue SOULBOUND_LOOT;
        public static ForgeConfigSpec.IntValue SQUIRREL_REFRESH_RATE;
        public static ForgeConfigSpec.BooleanValue MAGES_AGGRO;
        public static final Integer TREE_SPAWN_RATE;
        public static ForgeConfigSpec.IntValue EXTRA_BIOMES;

        public Common(ForgeConfigSpec.Builder builder) {
            this.LesserFocusDiscount = builder.comment("Adjust this value to define how much the matching spell cost gets discounted by the lesser focus").defineInRange("Elemental Focus discount", 0.15, 0.0, 0.99);
            this.MajorFocusDiscount = builder.comment("Adjust this value to define how much the matching spell cost gets discounted by the greater focus").defineInRange("Elemental Focus discount", 0.25, 0.0, 0.99);
            builder.comment("Adjust these values to balance how much a spell gets amplified by the matching spell focus, doubled for major foci.").push("Elemental Spell Foci - Amplify");
            this.FireMasteryBuff = builder.define("Fire Focus buff", (Object)1.0);
            this.WaterMasteryBuff = builder.define("Water Focus buff", (Object)1.0);
            this.AirMasteryBuff = builder.define("Air Focus buff", (Object)1.0);
            this.EarthMasteryBuff = builder.define("Earth Focus buff", (Object)1.0);
            builder.pop();
            builder.comment("Adjust these values to balance how much an elemental spell gets dampened by a not-matching lesser spell focus").push("Elemental Spell Foci - Dampening");
            this.FireMasteryDebuff = builder.define("Fire Focus debuff", (Object)-1.0);
            this.WaterMasteryDebuff = builder.define("Water Focus debuff", (Object)-1.0);
            this.AirMasteryDebuff = builder.define("Air Focus debuff", (Object)-1.0);
            this.EarthMasteryDebuff = builder.define("Earth Focus debuff", (Object)-1.0);
            builder.pop();
            builder.comment("Enable or disable the passive bonus of the foci").push("Elemental Spell Foci - Abilities");
            this.EnableGlyphEmpowering = builder.define("Enable glyph empowering", true);
            this.EnableRegenBonus = builder.define("Enable regen bonus under special conditions", true);
            builder.pop();
            builder.comment("Adjust Elemental Armor Mana Buffs").push("Elemental Armors");
            ARMOR_MAX_MANA = builder.comment("Max mana bonus for each elemental armor piece").defineInRange("armorMaxMana", 100, 0, 10000);
            ARMOR_MANA_REGEN = builder.comment("Mana regen bonus for each elemental armor piece").defineInRange("armorManaRegen", 4, 0, 100);
            builder.pop();
            builder.push("Mermaid Fishing");
            SIREN_MANA_COST = builder.comment("How much source mermaids consume per generation").defineInRange("mermaidManaCost", 1000, 0, 10000);
            SIREN_MAX_PROGRESS = builder.comment("How many channels must occur before a siren produces loot.").defineInRange("mermaidMaxProgress", 30, 0, 300);
            SIREN_UNIQUE_BONUS = builder.comment("Max number of extra item rolls a shrine produces if the mood is high.").defineInRange("mermaidScoreBonus", 2, 0, 10);
            SIREN_TREASURE_BONUS = builder.comment("Chance multiplier to produce a treasure relative to the siren shrine score.").defineInRange("mermaidTreasureBonus", 0.002, 0.0, 1.0);
            SIREN_BASE_ITEM = builder.comment("Base number of items rolls a shrine produces per cycle.").defineInRange("mermaidBaseItems", 1, 0, 300);
            SIREN_QUANTITY_CAP = builder.comment("Max number of items a siren shrine can produce per cycle.").defineInRange("mermaidQuantityCap", 5, 0, 300);
            builder.pop();
            builder.push("Source cost");
            WATER_URN_COST = builder.comment("How much source does the water urn consume.").defineInRange("waterUrnCost", 100, 0, 10000);
            AIR_ELEVATOR_COST = builder.comment("How much source does the slipstream elevator consume.").defineInRange("airElevatorCost", 10, 0, 1000);
            WATER_ELEVATOR_COST = builder.comment("How much source does the bubble elevator consume.").defineInRange("waterElevatorCost", 0, 0, 1000);
            LAVA_ELEVATOR_COST = builder.comment("How much source does the magmatic elevator consume.").defineInRange("lavaElevatorCost", 0, 0, 1000);
            builder.pop();
            builder.push("Misc");
            FIRENANDO_KILL = builder.comment("If enabled, flarecannons will simply die and drop the charm, instead of deactivating, if killed by their owner").define("flarecannon_owner_kill", true);
            EXTRA_BIOMES = builder.comment("Set over 0 to enable archwood forests with specific trees").defineInRange("extra_biomes", 0, 0, 100);
            LIGHTNINGS_BIOME = builder.comment("Set to false to disable the lightning crashing often on flashing archwood biome(s).").define("always_thunder", true);
            HOMING_GLOWING = builder.comment("If enabled, homing will be able to target mobs only if they're glowing").define("homing_nerf", false);
            SQUIRREL_REFRESH_RATE = builder.comment("Define the refresh rate of the Squirrel Ritual buff, in ticks.").defineInRange("squirrelRefreshRate", 600, 1, Integer.MAX_VALUE);
            SOULBOUND_LOOT = builder.comment("If enabled, soulbound enchantment can appear in randomly enchanted loot chests.").define("soulbound_loot", true);
            builder.pop();
            builder.push("Mobs-Disabled");
            MAGES_AGGRO = builder.comment("If true, the wandering mages will target players too, unless they wear the focus of the same school.").define("magesAggro", true);
            builder.pop();
        }

        static {
            TREE_SPAWN_RATE = 200;
        }
    }

    public static class Client {
        public static ForgeConfigSpec.ConfigValue<Boolean> EnableSFRendering;
        public static ForgeConfigSpec.ConfigValue<Boolean> NetheriteTexture;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("Visual Configs");
            EnableSFRendering = builder.comment("Enables the rendering of the spell focus while equipped").define("Enable SpellFocusRender", true);
            NetheriteTexture = builder.comment("Enables the black texture of the spell book while upgraded").define("Enable BlackBookTexture", true);
            builder.pop();
        }
    }
}

