/*
 * Decompiled with CFR 0.152.
 */
package appeng.shaded.methvin.watcher.visitor;

import appeng.shaded.methvin.watcher.visitor.FileTreeVisitor;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class DefaultFileTreeVisitor
implements FileTreeVisitor {
    @Override
    public void recursiveVisitFiles(Path path, final FileTreeVisitor.Callback callback, final FileTreeVisitor.Callback callback2) throws IOException {
        SimpleFileVisitor<Path> simpleFileVisitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                callback.call(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                callback2.call(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
                DefaultFileTreeVisitor.this.onFailure(path, iOException);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                if (iOException != null) {
                    DefaultFileTreeVisitor.this.onFailure(path, iOException);
                }
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(path, (FileVisitor<? super Path>)simpleFileVisitor);
    }

    protected void onFailure(Path path, IOException iOException) throws IOException {
    }
}

