/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.render;

import appeng.client.gui.Icon;
import appeng.client.gui.style.BackgroundGenerator;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.render.ColorRef;
import appeng.client.guidebook.render.GuidePageTexture;
import appeng.client.guidebook.render.LightDarkMode;
import appeng.client.guidebook.style.ResolvedTextStyle;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;

public interface RenderContext {
    public LightDarkMode lightDarkMode();

    default public boolean isDarkMode() {
        return this.lightDarkMode() == LightDarkMode.DARK_MODE;
    }

    public PoseStack poseStack();

    public LytRect viewport();

    public int resolveColor(ColorRef var1);

    public void fillRect(LytRect var1, ColorRef var2, ColorRef var3, ColorRef var4, ColorRef var5);

    default public void fillTexturedRect(LytRect rect, AbstractTexture texture, ColorRef topLeft, ColorRef topRight, ColorRef bottomRight, ColorRef bottomLeft) {
        this.fillTexturedRect(rect, texture, topLeft, topRight, bottomRight, bottomLeft, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public void fillTexturedRect(LytRect var1, AbstractTexture var2, ColorRef var3, ColorRef var4, ColorRef var5, ColorRef var6, float var7, float var8, float var9, float var10);

    default public void fillTexturedRect(LytRect rect, GuidePageTexture texture) {
        this.fillTexturedRect(rect, texture.use(), ColorRef.WHITE);
    }

    default public void fillTexturedRect(LytRect rect, AbstractTexture texture) {
        this.fillTexturedRect(rect, texture, ColorRef.WHITE);
    }

    default public void fillTexturedRect(LytRect rect, AbstractTexture texture, ColorRef color) {
        this.fillTexturedRect(rect, texture, color, color, color, color);
    }

    default public void fillTexturedRect(LytRect rect, GuidePageTexture texture, ColorRef color) {
        this.fillTexturedRect(rect, texture.use(), color, color, color, color);
    }

    default public void fillTexturedRect(LytRect rect, TextureAtlasSprite sprite, ColorRef color) {
        this.fillTexturedRect(rect, (AbstractTexture)sprite.m_118414_(), color, color, color, color, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_());
    }

    default public void drawIcon(int x, int y, Icon icon, ColorRef color) {
        float u0 = (float)icon.x / 256.0f;
        float v0 = (float)icon.y / 256.0f;
        float u1 = (float)(icon.x + icon.width) / 256.0f;
        float v1 = (float)(icon.y + icon.height) / 256.0f;
        AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(Icon.TEXTURE);
        this.fillTexturedRect(new LytRect(x, y, icon.width, icon.height), texture, color, color, color, color, u0, v0, u1, v1);
    }

    default public void fillTexturedRect(LytRect rect, ResourceLocation textureId) {
        this.fillTexturedRect(rect, textureId, ColorRef.WHITE);
    }

    default public void fillTexturedRect(LytRect rect, ResourceLocation textureId, ColorRef color) {
        AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(textureId);
        this.fillTexturedRect(rect, texture, color);
    }

    public void fillTriangle(Vec2 var1, Vec2 var2, Vec2 var3, ColorRef var4);

    default public Font font() {
        return Minecraft.m_91087_().f_91062_;
    }

    default public float getAdvance(int codePoint, ResolvedTextStyle style) {
        return this.font().m_92863_(style.font()).m_243128_(codePoint, false).m_83827_(Boolean.TRUE.equals(style.bold()));
    }

    default public float getWidth(String text, ResolvedTextStyle style) {
        return (float)text.codePoints().mapToDouble(cp -> this.getAdvance(cp, style)).sum();
    }

    default public void renderText(String text, ResolvedTextStyle style, float x, float y) {
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        this.renderTextInBatch(text, style, x, y, (MultiBufferSource)bufferSource);
        bufferSource.m_109911_();
    }

    default public void renderTextInBatch(String text, ResolvedTextStyle style, float x, float y, MultiBufferSource buffers) {
        Style effectiveStyle = Style.f_131099_.m_131136_(Boolean.valueOf(style.bold())).m_131155_(Boolean.valueOf(style.italic())).m_131162_(Boolean.valueOf(style.underlined())).m_178522_(Boolean.valueOf(style.strikethrough())).m_131150_(style.font());
        Matrix4f matrix = this.poseStack().m_85850_().m_85861_();
        if (style.fontScale() != 1.0f) {
            matrix = matrix.m_27658_();
            matrix.m_162199_(style.fontScale(), style.fontScale(), 1.0f);
            matrix.m_27648_(new Vector3f(x, y, 0.0f));
            x = 0.0f;
            y = 0.0f;
        }
        this.font().m_92841_((Component)Component.m_237113_((String)text).m_130948_(effectiveStyle), x, y, this.resolveColor(style.color()), false, matrix, buffers, false, 0, 0xF000F0);
    }

    default public void fillRect(int x, int y, int width, int height, ColorRef color) {
        this.fillRect(new LytRect(x, y, width, height), color);
    }

    default public void fillRect(LytRect rect, ColorRef color) {
        this.fillRect(rect, color, color, color, color);
    }

    default public void fillGradientVertical(LytRect rect, ColorRef top, ColorRef bottom) {
        this.fillRect(rect, top, top, bottom, bottom);
    }

    default public void fillGradientVertical(int x, int y, int width, int height, ColorRef top, ColorRef bottom) {
        this.fillGradientVertical(new LytRect(x, y, width, height), top, bottom);
    }

    default public void fillGradientHorizontal(LytRect rect, ColorRef left, ColorRef right) {
        this.fillRect(rect, left, right, right, left);
    }

    default public void fillGradientHorizontal(int x, int y, int width, int height, ColorRef left, ColorRef right) {
        this.fillGradientHorizontal(new LytRect(x, y, width, height), left, right);
    }

    default public MultiBufferSource.BufferSource beginBatch() {
        return MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
    }

    default public void endBatch(MultiBufferSource.BufferSource batch) {
        batch.m_109911_();
    }

    default public void renderItem(ItemStack stack, int x, int y, float width, float height) {
        this.renderItem(stack, x, y, 0, width, height);
    }

    public void renderItem(ItemStack var1, int var2, int var3, int var4, float var5, float var6);

    default public void renderPanel(LytRect bounds) {
        BackgroundGenerator.draw(bounds.width(), bounds.height(), this.poseStack(), 0, bounds.x(), bounds.y());
    }
}

