/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.client.container;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.smashingmods.alchemistry.Alchemistry;
import com.smashingmods.alchemistry.client.container.RecipeDisplayUtil;
import com.smashingmods.alchemistry.common.network.SetRecipePacket;
import com.smashingmods.alchemylib.api.blockentity.container.AbstractProcessingScreen;
import com.smashingmods.alchemylib.api.blockentity.processing.AbstractSearchableBlockEntity;
import com.smashingmods.alchemylib.api.recipe.AbstractProcessingRecipe;
import com.smashingmods.alchemylib.api.recipe.ProcessingRecipe;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeSelectorScreen<P extends AbstractProcessingScreen<?>, B extends AbstractSearchableBlockEntity, R extends AbstractProcessingRecipe>
extends Screen {
    private final int imageWidth = 184;
    private final int imageHeight = 162;
    private int leftPos;
    private int topPos;
    private int recipeBoxLeftPos;
    private int recipeBoxTopPos;
    private final P parentScreen;
    private final B blockEntity;
    private final LinkedList<R> recipes;
    private final LinkedList<AbstractProcessingRecipe> displayedRecipes = new LinkedList();
    private final EditBox searchBox;
    private static final int MAX_DISPLAYED_RECIPES = 30;
    private static final int COLUMNS = 5;
    private static final int RECIPE_BOX_SIZE = 18;
    private float scrollOffset;
    private boolean scrolling;
    private int startIndex;

    public RecipeSelectorScreen(P pParentScreen, B pBlockEntity, LinkedList<R> pRecipes) {
        super((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("")));
        this.parentScreen = pParentScreen;
        this.blockEntity = pBlockEntity;
        this.recipes = pRecipes;
        this.searchBox = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 92, 12, (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("")));
        if (!this.blockEntity.getSearchText().isEmpty()) {
            this.searchBox.m_94144_(this.blockEntity.getSearchText());
            this.searchRecipeList(this.blockEntity.getSearchText());
        }
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 184) / 2;
        this.recipeBoxLeftPos = this.leftPos + 58;
        this.recipeBoxTopPos = this.topPos + 26;
        super.m_7856_();
    }

    public void m_86600_() {
        if (this.searchBox.m_94155_().isEmpty()) {
            this.blockEntity.setSearchText("");
            this.resetDisplayedRecipes();
            this.searchBox.m_94167_(I18n.m_118938_((String)"alchemistry.container.search", (Object[])new Object[0]));
        } else {
            if (this.displayedRecipes.size() < 30) {
                this.m_6050_(0.0, 0.0, 0.0);
                this.scrollOffset = 0.0f;
            }
            this.blockEntity.setSearchText(this.searchBox.m_94155_());
            this.searchRecipeList(this.searchBox.m_94155_());
            if (this.displayedRecipes.size() <= 30) {
                this.startIndex = 0;
                this.scrollOffset = 0.0f;
            }
            this.searchBox.m_94167_("");
        }
        super.m_86600_();
    }

    public void m_7379_() {
        this.blockEntity.setRecipeSelectorOpen(false);
        super.m_7379_();
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBg(pPoseStack);
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderRecipeBox(pPoseStack, pMouseX, pMouseY);
        this.renderWidget(this.searchBox, this.leftPos + 58, this.topPos + 11);
        this.renderParentTooltips(pPoseStack, pMouseX, pMouseY);
    }

    private void renderBg(PoseStack pPoseStack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("alchemistry", "textures/gui/recipe_select_gui.png"));
        this.m_93228_(pPoseStack, this.leftPos, this.topPos, 0, 0, 184, 162);
    }

    private void renderRecipeBox(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("alchemistry", "textures/gui/recipe_select_gui.png"));
        int lastDisplayedIndex = this.startIndex + 30;
        this.renderScrollbar(pPoseStack);
        this.renderRecipeButtons(pPoseStack, pMouseX, pMouseY, lastDisplayedIndex);
        this.renderRecipeButtonItems(pPoseStack, pMouseX, pMouseY, lastDisplayedIndex);
        this.renderCurrentRecipe(pPoseStack, pMouseX, pMouseY);
    }

    private void renderScrollbar(PoseStack pPoseStack) {
        int scrollPosition = (int)(93.0f * this.scrollOffset);
        this.m_93228_(pPoseStack, this.leftPos + 154, this.topPos + 28 + scrollPosition, 18 + (this.isScrollBarActive() ? 0 : 12), 162, 12, 15);
    }

    private void renderRecipeButtons(PoseStack pPoseStack, int pMouseX, int pMouseY, int pLastDisplayedIndex) {
        for (int index = this.startIndex; index < pLastDisplayedIndex && index < this.getDisplayedRecipes().size(); ++index) {
            int firstDisplayedIndex = index - this.startIndex;
            int xStart = this.recipeBoxLeftPos + firstDisplayedIndex % 5 * 18;
            int yStart = this.recipeBoxTopPos + firstDisplayedIndex / 5 * 18 + 2;
            int vOffset = 162;
            int currentRecipeIndex = this.getDisplayedRecipes().indexOf(this.blockEntity.getRecipe());
            if (index == currentRecipeIndex) {
                vOffset += 18;
            } else if (pMouseX >= xStart && pMouseX < xStart + 18 && pMouseY >= yStart && pMouseY < yStart + 18) {
                vOffset += 36;
            }
            this.m_93228_(pPoseStack, xStart, yStart, 0, vOffset, 18, 18);
        }
    }

    private void renderRecipeButtonItems(PoseStack pPoseStack, int pMouseX, int pMouseY, int pLastDisplayedIndex) {
        LinkedList<AbstractProcessingRecipe> displayedRecipes = this.getDisplayedRecipes();
        for (int index = this.startIndex; index >= 0 && index < pLastDisplayedIndex && index < displayedRecipes.size(); ++index) {
            int firstDisplayedIndex = index - this.startIndex;
            ItemStack target = RecipeDisplayUtil.getTarget((ProcessingRecipe)this.getDisplayedRecipes().get(index));
            int xStart = this.recipeBoxLeftPos + firstDisplayedIndex % 5 * 18 + 1;
            int yStart = this.recipeBoxTopPos + firstDisplayedIndex / 5 * 18 + 3;
            this.renderFloatingItem(target, xStart, yStart);
            if (pMouseX < xStart - 1 || pMouseX > xStart + 16 || pMouseY < yStart - 1 || pMouseY > yStart + 16) continue;
            List<Component> components = RecipeDisplayUtil.getItemTooltipComponent(target, MutableComponent.m_237204_((ComponentContents)new TranslatableContents("alchemistry.container.select_recipe")));
            this.m_169388_(pPoseStack, components, Optional.empty(), pMouseX, pMouseY);
        }
    }

    private void renderFloatingItem(ItemStack pItemStack, int pX, int pY) {
        RenderSystem.m_157182_();
        this.m_93250_(2000);
        this.f_96542_.f_115093_ = 2000.0f;
        this.f_96542_.m_115203_(pItemStack, pX, pY);
        this.f_96542_.m_115174_(this.f_96547_, pItemStack, pX, pY, null);
        this.m_93250_(0);
        this.f_96542_.f_115093_ = 0.0f;
    }

    private void renderCurrentRecipe(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        AbstractProcessingRecipe recipe = this.blockEntity.getRecipe();
        if (recipe != null) {
            this.recipeLooper((arg_0, arg_1, arg_2, arg_3) -> this.lambda$renderCurrentRecipe$0((ProcessingRecipe)recipe, pPoseStack, arg_0, arg_1, arg_2, arg_3));
            this.recipeLooper((arg_0, arg_1, arg_2, arg_3) -> this.lambda$renderCurrentRecipe$1((ProcessingRecipe)recipe, pMouseX, pMouseY, pPoseStack, arg_0, arg_1, arg_2, arg_3));
            ItemStack target = RecipeDisplayUtil.getTarget((ProcessingRecipe)recipe);
            this.renderFloatingItem(target, this.leftPos + 21, this.topPos + 30);
            if (pMouseX >= this.leftPos + 17 && pMouseX < this.leftPos + 41 && pMouseY >= this.topPos + 27 && pMouseY <= this.topPos + 50) {
                List<Component> components = RecipeDisplayUtil.getItemTooltipComponent(target, MutableComponent.m_237204_((ComponentContents)new TranslatableContents("alchemistry.container.current_recipe")));
                this.m_169388_(pPoseStack, components, Optional.empty(), pMouseX, pMouseY);
            }
        } else {
            this.recipeLooper((pIndex, pInputSize, pX, pY) -> this.renderSlot(pPoseStack, pX, pY));
        }
    }

    private void recipeLooper(LoopConsumer pConsumer) {
        int inputSize = RecipeDisplayUtil.getInputSize(this.blockEntity);
        int totalRows = inputSize / 2 + inputSize % 2;
        int totalCols = inputSize / 2 + inputSize % 2;
        int xOrigin = totalRows == 1 ? this.leftPos + 20 : this.leftPos + 11;
        int yOrigin = this.topPos + 59;
        for (int row = 0; row < totalRows; ++row) {
            for (int col = 0; col < totalCols; ++col) {
                int index = col + row * 2;
                int x = xOrigin + col * 18;
                int y = yOrigin + row * 18;
                pConsumer.accept(index, inputSize, x, y);
            }
        }
    }

    private void renderSlot(PoseStack pPoseStack, int pX, int pY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("alchemistry", "textures/gui/recipe_select_gui.png"));
        this.m_93228_(pPoseStack, pX, pY, 0, 216, 18, 18);
    }

    public <W extends GuiEventListener & Widget> void renderWidget(W pWidget, int pX, int pY) {
        if (!this.f_169369_.contains(pWidget)) {
            if (pWidget instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)pWidget;
                widget.f_93620_ = pX;
                widget.f_93621_ = pY;
            }
            this.m_142416_(pWidget);
        }
    }

    public void renderParentTooltips(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        for (Widget renderable : ((AbstractProcessingScreen)this.parentScreen).f_169369_) {
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)renderable;
            int xStart = widget.f_93620_;
            int xEnd = xStart + widget.m_5711_();
            int yStart = widget.f_93621_;
            int yEnd = yStart + widget.m_93694_();
            if (pMouseX <= xStart || pMouseX >= xEnd || pMouseY <= yStart || pMouseY >= yEnd) continue;
            this.m_96602_(pPoseStack, widget.m_6035_(), pMouseX, pMouseY);
        }
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 69 && this.searchBox.m_93696_()) {
            return false;
        }
        if (pKeyCode == 258 && !this.searchBox.m_93696_()) {
            this.searchBox.m_94178_(true);
            this.searchBox.m_94186_(true);
            this.searchBox.f_93623_ = true;
        } else if (pKeyCode == 256 && this.searchBox.m_93696_()) {
            this.searchBox.m_94178_(false);
            this.searchBox.m_94186_(false);
            this.searchBox.f_93623_ = false;
            return false;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        Objects.requireNonNull(Minecraft.m_91087_().f_91072_);
        int searchBoxMinX = this.leftPos + 56;
        int searchBoxMaxX = searchBoxMinX + 72;
        int searchBoxMinY = this.topPos + 12;
        int searchBoxMaxY = searchBoxMinY + 12;
        if (pMouseX >= (double)searchBoxMinX && pMouseX < (double)searchBoxMaxX && pMouseY >= (double)searchBoxMinY && pMouseY < (double)searchBoxMaxY) {
            this.searchBox.m_94178_(true);
            this.searchBox.m_94186_(true);
            this.searchBox.f_93623_ = true;
        } else if (this.searchBox.m_93696_() || this.searchBox.m_142518_()) {
            this.searchBox.m_94178_(false);
            this.searchBox.f_93623_ = false;
        }
        this.scrolling = false;
        int lastDisplayedIndex = this.startIndex + 30;
        for (int index = this.startIndex; index < lastDisplayedIndex; ++index) {
            int currentIndex = index - this.startIndex;
            double boxX = pMouseX - (double)(this.recipeBoxLeftPos + currentIndex % 5 * 18);
            double boxY = pMouseY - (double)(this.recipeBoxTopPos + currentIndex / 5 * 18);
            if (boxX > 0.0 && boxX <= 19.0 && boxY > 0.0 && boxY <= 19.0 && !this.blockEntity.isRecipeLocked() && this.isValidRecipeIndex(index)) {
                AbstractProcessingRecipe recipe = this.getDisplayedRecipes().get(index);
                Alchemistry.PACKET_HANDLER.sendToServer(new SetRecipePacket(this.blockEntity.m_58899_(), recipe.m_6423_(), recipe.m_6076_()));
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                return true;
            }
            int scrollMinX = this.leftPos + 154;
            int scrollMinY = this.topPos + 28;
            int scrollMaxX = scrollMinX + 12;
            int scrollMaxY = scrollMinY + 108;
            if (!(pMouseX >= (double)scrollMinX) || !(pMouseX < (double)scrollMaxX) || !(pMouseY >= (double)scrollMinY) || !(pMouseY < (double)scrollMaxY)) continue;
            this.scrolling = true;
        }
        for (Widget renderable : ((AbstractProcessingScreen)this.parentScreen).f_169369_) {
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)renderable;
            int xStart = widget.f_93620_;
            int xEnd = xStart + widget.m_5711_();
            int yStart = widget.f_93621_;
            int yEnd = yStart + widget.m_93694_();
            if (!(pMouseX > (double)xStart) || !(pMouseX < (double)xEnd) || !(pMouseY > (double)yStart) || !(pMouseY < (double)yEnd)) continue;
            return this.parentScreen.m_6375_(pMouseX, pMouseY, pButton);
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int scrollbarTopPos = this.topPos + 28;
            int scrollbarBottomPos = scrollbarTopPos + 108;
            this.scrollOffset = ((float)pMouseY - (float)scrollbarTopPos - 7.5f) / ((float)(scrollbarBottomPos - scrollbarTopPos) - 15.0f);
            this.scrollOffset = Mth.m_14036_((float)this.scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffset * (float)this.getOffscreenRows()) + 0.5) * 5;
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (pMouseX >= (double)this.leftPos && pMouseX < (double)(this.leftPos + 184) && pMouseY >= (double)this.topPos && pMouseY < (double)(this.topPos + 162) && this.isScrollBarActive()) {
            this.scrollOffset = Mth.m_14036_((float)(this.scrollOffset - (float)pDelta / (float)this.getOffscreenRows()), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffset * (float)this.getOffscreenRows()) + 0.5) * 5;
        }
        return true;
    }

    private int getOffscreenRows() {
        return (this.displayedRecipes.size() + 6 - 1) / 6 - 3;
    }

    public void setTopPos(int topPos) {
        this.topPos = topPos;
    }

    public LinkedList<AbstractProcessingRecipe> getDisplayedRecipes() {
        return this.displayedRecipes;
    }

    public boolean m_7043_() {
        return false;
    }

    private boolean isScrollBarActive() {
        return this.displayedRecipes.size() > 30;
    }

    private boolean isValidRecipeIndex(int pSlot) {
        return pSlot >= 0 && pSlot < this.getDisplayedRecipes().size();
    }

    public void resetDisplayedRecipes() {
        this.displayedRecipes.clear();
        this.displayedRecipes.addAll(this.recipes);
        this.displayedRecipes.sort((r1, r2) -> r1.m_6423_().compareNamespaced(r2.m_6423_()));
    }

    private void searchRecipeList(String pKeyword) {
        this.getDisplayedRecipes().clear();
        LinkedList recipes = this.blockEntity.getAllRecipes().stream().filter(recipe -> {
            Pair<ResourceLocation, String> searchablePair = RecipeDisplayUtil.getSearchablePair((ProcessingRecipe)recipe);
            ResourceLocation registryName = (ResourceLocation)searchablePair.getLeft();
            String description = (String)searchablePair.getRight();
            String keyword = pKeyword.toLowerCase();
            if (keyword.charAt(0) == '@') {
                if (keyword.contains(" ")) {
                    if (keyword.split(" ").length > 1) {
                        String[] splitKeyword = keyword.split(" ");
                        return registryName.m_135827_().contains(splitKeyword[0].substring(1)) && registryName.m_135815_().contains(splitKeyword[1]);
                    }
                    return registryName.m_135827_().contains(keyword.substring(1, keyword.length() - 1));
                }
                return registryName.m_135827_().contains(keyword.substring(1));
            }
            return description.toLowerCase().contains(keyword);
        }).collect(Collectors.toCollection(LinkedList::new));
        this.getDisplayedRecipes().addAll(recipes);
    }

    private /* synthetic */ void lambda$renderCurrentRecipe$1(ProcessingRecipe recipe, int pMouseX, int pMouseY, PoseStack pPoseStack, int pIndex, int pInputSize, int pX, int pY) {
        if (pIndex < pInputSize && this.blockEntity.getInputHandler().getStackInSlot(pIndex).m_41619_()) {
            ItemStack itemStack = RecipeDisplayUtil.getRecipeInputByIndex(recipe, pIndex);
            if (pMouseX >= pX - 1 && pMouseX < pX + 17 && pMouseY >= pY - 1 && pMouseY < pY + 17 && !itemStack.m_41619_()) {
                List<Component> components = RecipeDisplayUtil.getItemTooltipComponent(itemStack, MutableComponent.m_237204_((ComponentContents)new TranslatableContents("alchemistry.container.required_input")));
                this.m_169388_(pPoseStack, components, Optional.empty(), pMouseX, pMouseY);
            }
        }
    }

    private /* synthetic */ void lambda$renderCurrentRecipe$0(ProcessingRecipe recipe, PoseStack pPoseStack, int pIndex, int pInputSize, int pX, int pY) {
        if (pIndex < pInputSize && this.blockEntity.getInputHandler().getStackInSlot(pIndex).m_41619_()) {
            ItemStack itemStack = RecipeDisplayUtil.getRecipeInputByIndex(recipe, pIndex);
            this.renderSlot(pPoseStack, pX, pY);
            this.renderFloatingItem(itemStack, pX + 1, pY + 1);
        }
    }

    @FunctionalInterface
    static interface LoopConsumer {
        public void accept(int var1, int var2, int var3, int var4);
    }
}

