/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.util;

import earth.terrarium.ad_astra.client.registry.ClientModKeybindings;
import earth.terrarium.ad_astra.common.networking.packet.client.KeybindPacket;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModKeyBindings {
    public static final HashMap<UUID, ModKeyBindings> PLAYER_KEYS = new HashMap();
    private boolean clickingJump;
    private boolean clickingSprint;
    private boolean clickingForward;
    private boolean clickingBack;
    private boolean clickingLeft;
    private boolean clickingRight;

    public static boolean jumpKeyDown(Player player) {
        return player.f_19853_.f_46443_ ? ModKeyBindings.getClientKeyPressed(player, KeybindPacket.Keybind.JUMP) : ModKeyBindings.getServerKeyPressed(player, KeybindPacket.Keybind.JUMP);
    }

    public static boolean sprintKeyDown(Player player) {
        return player.f_19853_.f_46443_ ? ModKeyBindings.getClientKeyPressed(player, KeybindPacket.Keybind.SPRINT) : ModKeyBindings.getServerKeyPressed(player, KeybindPacket.Keybind.SPRINT);
    }

    public static boolean forwardKeyDown(Player player) {
        return player.f_19853_.f_46443_ ? ModKeyBindings.getClientKeyPressed(player, KeybindPacket.Keybind.FORWARD) : ModKeyBindings.getServerKeyPressed(player, KeybindPacket.Keybind.FORWARD);
    }

    public static boolean backKeyDown(Player player) {
        return player.f_19853_.f_46443_ ? ModKeyBindings.getClientKeyPressed(player, KeybindPacket.Keybind.BACK) : ModKeyBindings.getServerKeyPressed(player, KeybindPacket.Keybind.BACK);
    }

    public static boolean leftKeyDown(Player player) {
        return player.f_19853_.f_46443_ ? ModKeyBindings.getClientKeyPressed(player, KeybindPacket.Keybind.LEFT) : ModKeyBindings.getServerKeyPressed(player, KeybindPacket.Keybind.LEFT);
    }

    public static boolean rightKeyDown(Player player) {
        return player.f_19853_.f_46443_ ? ModKeyBindings.getClientKeyPressed(player, KeybindPacket.Keybind.RIGHT) : ModKeyBindings.getServerKeyPressed(player, KeybindPacket.Keybind.RIGHT);
    }

    private static boolean getServerKeyPressed(Player player, KeybindPacket.Keybind key) {
        PLAYER_KEYS.putIfAbsent(player.m_20148_(), new ModKeyBindings());
        return switch (key) {
            default -> throw new IncompatibleClassChangeError();
            case KeybindPacket.Keybind.JUMP -> ModKeyBindings.PLAYER_KEYS.get((Object)player.m_20148_()).clickingJump;
            case KeybindPacket.Keybind.SPRINT -> ModKeyBindings.PLAYER_KEYS.get((Object)player.m_20148_()).clickingSprint;
            case KeybindPacket.Keybind.FORWARD -> ModKeyBindings.PLAYER_KEYS.get((Object)player.m_20148_()).clickingForward;
            case KeybindPacket.Keybind.BACK -> ModKeyBindings.PLAYER_KEYS.get((Object)player.m_20148_()).clickingBack;
            case KeybindPacket.Keybind.LEFT -> ModKeyBindings.PLAYER_KEYS.get((Object)player.m_20148_()).clickingLeft;
            case KeybindPacket.Keybind.RIGHT -> ModKeyBindings.PLAYER_KEYS.get((Object)player.m_20148_()).clickingRight;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean getClientKeyPressed(Player player, KeybindPacket.Keybind key) {
        if (!player.m_20148_().equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
            return false;
        }
        return switch (key) {
            default -> throw new IncompatibleClassChangeError();
            case KeybindPacket.Keybind.JUMP -> ClientModKeybindings.clickingJump;
            case KeybindPacket.Keybind.SPRINT -> ClientModKeybindings.clickingSprint;
            case KeybindPacket.Keybind.FORWARD -> ClientModKeybindings.clickingForward;
            case KeybindPacket.Keybind.BACK -> ClientModKeybindings.clickingBack;
            case KeybindPacket.Keybind.LEFT -> ClientModKeybindings.clickingLeft;
            case KeybindPacket.Keybind.RIGHT -> ClientModKeybindings.clickingRight;
        };
    }

    public static void pressedKeyOnServer(UUID uuid, KeybindPacket.Keybind key, boolean keyDown) {
        PLAYER_KEYS.putIfAbsent(uuid, new ModKeyBindings());
        switch (key) {
            case JUMP: {
                ModKeyBindings.PLAYER_KEYS.get((Object)uuid).clickingJump = keyDown;
                break;
            }
            case SPRINT: {
                ModKeyBindings.PLAYER_KEYS.get((Object)uuid).clickingSprint = keyDown;
                break;
            }
            case FORWARD: {
                ModKeyBindings.PLAYER_KEYS.get((Object)uuid).clickingForward = keyDown;
                break;
            }
            case BACK: {
                ModKeyBindings.PLAYER_KEYS.get((Object)uuid).clickingBack = keyDown;
                break;
            }
            case LEFT: {
                ModKeyBindings.PLAYER_KEYS.get((Object)uuid).clickingLeft = keyDown;
                break;
            }
            case RIGHT: {
                ModKeyBindings.PLAYER_KEYS.get((Object)uuid).clickingRight = keyDown;
            }
        }
    }

    public static void onPlayerQuit(Player player) {
        PLAYER_KEYS.remove(player.m_20148_());
    }
}

