/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.blocks;

import java.awt.Color;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.CoreTags;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.IColorable;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.world.content.WorldContent;

public class RGBGlassBlock
extends GlassBlock
implements IColorable {
    public static final BooleanProperty Spawnable = BooleanProperty.m_61465_((String)"allow_spawns");
    private final int _color;
    private final DyeColor _dyeColor;
    private final float[] _beaconColors;

    public RGBGlassBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this._color = ColorUtils.getColorFromDye((DyeColor)color);
        this._dyeColor = color;
        this._beaconColors = new float[]{(float)(this._color >> 16 & 0xFF) / 255.0f, (float)(this._color >> 8 & 0xFF) / 255.0f, (float)(this._color & 0xFF) / 255.0f};
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)Spawnable, (Comparable)Boolean.valueOf(false)));
    }

    public static Supplier<Block> supplier(DyeColor color) {
        return () -> new RGBGlassBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)WorldContent.GlassViewer.block()));
    }

    public static Supplier<Block> supplierGlow(DyeColor color) {
        return () -> new RGBGlassBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)WorldContent.GlassViewer.block()).m_60953_(state -> 15));
    }

    public static Supplier<Item> itemSupplier(DyeColor dyeColor, RegistryObject<Block> blockRegistryObject) {
        return () -> new XyBlockItem((Block)blockRegistryObject.get(), dyeColor == DyeColor.WHITE ? new Item.Properties().m_41491_(WorldContent.Tab) : new Item.Properties());
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        if (player.m_7500_()) {
            return super.getCloneItemStack(state, target, level, pos, player);
        }
        if (WorldContent.GlassViewerRgbGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) {
            return new ItemStack((ItemLike)WorldContent.GlassViewerRgbGlowing.get(DyeColor.WHITE).block(), 1);
        }
        return new ItemStack((ItemLike)WorldContent.GlassViewerRgb.get(DyeColor.WHITE).block(), 1);
    }

    public float @Nullable [] getBeaconColorMultiplier(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        return this._beaconColors;
    }

    public boolean m_6104_(@NotNull BlockState state, BlockState other, @NotNull Direction direction) {
        return other.m_204336_(CoreTags.Blocks.TAGGG) || super.m_6104_(state, other, direction);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hit) {
        DyeColor dyeColor;
        InteractionResult interactionResult = ColoredBlock.tryToAllowSpawns((BlockState)state, (Level)level, (BlockPos)pos, (Player)player, (InteractionHand)interactionHand);
        if (interactionResult != InteractionResult.PASS) {
            return interactionResult;
        }
        ItemStack stack = player.m_21120_(interactionHand);
        if (interactionHand == InteractionHand.MAIN_HAND && stack.m_41619_() && player.m_6144_()) {
            if (WorldContent.GlassViewerRgbGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) {
                if (!level.m_5776_() && !player.m_7500_()) {
                    Direction dir = hit.m_82434_();
                    Vec3 itemPos = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_231075_(dir, 0.67);
                    double d0 = (double)(level.f_46441_.m_188501_() * 0.4f) + 0.15;
                    double d1 = (double)(level.f_46441_.m_188501_() * 0.4f) + 0.15;
                    double d2 = (double)(level.f_46441_.m_188501_() * 0.4f) + 0.15;
                    ItemEntity itementity = new ItemEntity(level, itemPos.f_82479_ + d0, itemPos.f_82480_ + d1, itemPos.f_82481_ + d2, new ItemStack((ItemLike)Items.f_151056_));
                    itementity.m_32060_();
                    level.m_7967_((Entity)itementity);
                }
                level.m_46597_(pos, (BlockState)WorldContent.GlassViewerRgb.get(this._dyeColor).block().m_49966_().m_61124_((Property)Spawnable, (Comparable)((Boolean)state.m_61143_((Property)Spawnable))));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        if (stack.m_41720_() == Items.f_151056_) {
            if (WorldContent.GlassViewerRgbGlowing.values().stream().map(BlockContent::block).noneMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_220040_((ServerPlayer)player, pos, stack);
                }
                stack.m_41774_(player.m_7500_() ? 0 : 1);
                level.m_46597_(pos, (BlockState)WorldContent.GlassViewerRgbGlowing.get(this._dyeColor).block().m_49966_().m_61124_((Property)Spawnable, (Comparable)((Boolean)state.m_61143_((Property)Spawnable))));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        if ((dyeColor = DyeColor.getColor((ItemStack)stack)) != null) {
            BlockContent rgbViewer;
            BlockContent blockContent = rgbViewer = WorldContent.GlassViewerRgbGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0)) ? WorldContent.GlassViewerRgbGlowing.get(dyeColor) : WorldContent.GlassViewerRgb.get(dyeColor);
            if (rgbViewer.block() != this) {
                level.m_7731_(pos, (BlockState)rgbViewer.block().m_49966_().m_61124_((Property)Spawnable, (Comparable)((Boolean)state.m_61143_((Property)Spawnable))), 11);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return super.m_6227_(state, level, pos, player, interactionHand, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{Spawnable});
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        ItemStack offhandStack = Objects.requireNonNull(context.m_43723_()).m_21206_();
        DyeColor color = DyeColor.getColor((ItemStack)offhandStack);
        BlockState state = this.m_49966_();
        if (color != null) {
            state = WorldContent.GlassViewerRgbGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0)) ? WorldContent.GlassViewerRgbGlowing.get(color).block().m_49966_() : WorldContent.GlassViewerRgb.get(color).block().m_49966_();
        }
        return (BlockState)state.m_61124_((Property)Spawnable, (Comparable)Boolean.valueOf(false));
    }

    public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return entityType == EntityType.f_20532_ || (Boolean)state.m_61143_((Property)Spawnable) != false;
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        return index != 0 ? -1 : this._color;
    }

    public int getColorOfItem(ItemStack stack, int index) {
        if (index != 0) {
            return -1;
        }
        if (stack.m_41720_() == WorldContent.GlassViewerRgb.get(DyeColor.WHITE).item() || stack.m_41720_() == WorldContent.GlassViewerRgbGlowing.get(DyeColor.WHITE).item()) {
            return Color.HSBtoRGB((float)(System.currentTimeMillis() % 10000L) / 10000.0f, 1.0f, 1.0f);
        }
        return this._color;
    }
}

