/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.override;

import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.resource.PathPackResources;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="xycraft_override", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class XyCraftOverrideClient {
    @SubscribeEvent
    public static void onAddPackFinders(AddPackFindersEvent event) {
        try {
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                XyCraftOverrideClient.addPack(event, "xycraft_override", "OverridesStone", "add_xycraft_overrides_stone", "XyCraft Stone Overrides");
                XyCraftOverrideClient.addPack(event, "xycraft_override", "OverridesMetal", "add_xycraft_overrides_metal", "XyCraft Metal Overrides");
                XyCraftOverrideClient.addPack(event, "xycraft_override", "OverridesGlass", "add_xycraft_overrides_glass", "XyCraft Glass Overrides");
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void addPack(AddPackFindersEvent event, String modId, String path, String keyName, String packName) throws IOException {
        Path resourcePath = ModList.get().getModFileById(modId).getFile().findResource(new String[]{path});
        try (PathPackResources pack = new PathPackResources(ModList.get().getModFileById(modId).getFile().getFileName() + ":" + resourcePath, resourcePath);){
            PackMetadataSection metadataSection = (PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_10366_);
            if (metadataSection == null) {
                return;
            }
            event.addRepositorySource(XyCraftOverrideClient.getRepositorySource(pack, metadataSection, keyName, packName));
        }
    }

    @NotNull
    private static RepositorySource getRepositorySource(PathPackResources pack, PackMetadataSection metadataSection, String keyName, String packName) {
        return (packConsumer, packConstructor) -> packConsumer.accept(packConstructor.create("builtin/" + keyName, (Component)Component.m_237113_((String)packName), true, () -> pack, metadataSection, Pack.Position.TOP, PackSource.f_10528_, false));
    }
}

