/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.data;

import java.util.EnumMap;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.ContentRegistry;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.PillarColoredBlock;
import tv.soaryn.xycraft.core.data.BlockModelType;
import tv.soaryn.xycraft.core.data.ConnectedModelProvider;
import tv.soaryn.xycraft.core.data.CoreResources;

public abstract class BlockStateDataGen
extends BlockStateProvider {
    protected final String _modId;
    protected final ContentRegistry registryCache;

    public BlockStateDataGen(DataGenerator generator, ContentRegistry registry, String modID, ExistingFileHelper existingFileHelper) {
        super(generator, modID, existingFileHelper);
        this._modId = modID;
        this.registryCache = registry;
    }

    protected void registerStatesAndModels() {
        this.registryCache.ListOfBlocks.stream().filter(blockContent -> blockContent.getModelType() != BlockModelType.Custom).forEach(this::handleModel);
    }

    private void handleModel(BlockContent content) {
        switch (content.getModelType()) {
            case Block: {
                this.buildSimpleBlock(content);
                break;
            }
            case Connected: {
                this.buildConnectedBlock(content, this::cutout);
                break;
            }
            case Cloud: {
                this.buildCloudBlock(content);
                break;
            }
        }
    }

    protected void simple(ConnectedModelProvider<?> builder) {
    }

    protected void buildCloudPillar(BlockContent blockContent, BlockModelBuilder verticalModel, BlockModelBuilder horizontalModel) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(blockContent.block()).partialState().with((Property)ColoredBlock.Spawnable, (Comparable)Boolean.valueOf(false)).with(PillarColoredBlock.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)verticalModel).addModel()).partialState().with((Property)ColoredBlock.Spawnable, (Comparable)Boolean.valueOf(false)).with(PillarColoredBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)horizontalModel).rotationX(90).addModel()).partialState().with((Property)ColoredBlock.Spawnable, (Comparable)Boolean.valueOf(false)).with(PillarColoredBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)horizontalModel).rotationX(90).rotationY(90).addModel()).partialState().with((Property)ColoredBlock.Spawnable, (Comparable)Boolean.valueOf(true)).with(PillarColoredBlock.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)verticalModel).addModel()).partialState().with((Property)ColoredBlock.Spawnable, (Comparable)Boolean.valueOf(true)).with(PillarColoredBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)horizontalModel).rotationX(90).addModel()).partialState().with((Property)ColoredBlock.Spawnable, (Comparable)Boolean.valueOf(true)).with(PillarColoredBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)horizontalModel).rotationX(90).rotationY(90).addModel();
    }

    protected BlockModelBuilder cloudModelPillar(String modelPath, String parent) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelPath, parent)).texture("particle", CoreResources.CloudFX)).texture("cloud", CoreResources.CloudFX)).texture("side", CoreResources.CloudFX)).texture("end", CoreResources.CloudFX)).renderType("cutout");
        ModelBuilder.ElementBuilder elementCloud = model.element().shade(false).from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
        ModelBuilder.ElementBuilder elementPillar = model.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
        for (Direction direction : Direction.values()) {
            elementCloud = elementCloud.face(direction).texture("#cloud").emissive().cullface(direction).tintindex(0).ao(false).end();
            elementPillar = elementPillar.face(direction).texture(direction.m_122434_() == Direction.Axis.Y ? "#end" : "#side").rotation(direction == Direction.UP ? ModelBuilder.FaceRotation.UPSIDE_DOWN : ModelBuilder.FaceRotation.ZERO).cullface(direction).end();
        }
        return model;
    }

    protected void cutout(ConnectedModelProvider<?> builder) {
        builder.end().renderType("cutout");
    }

    protected void translucent(ConnectedModelProvider<?> builder) {
        builder.end().renderType("translucent");
    }

    protected void buildConnectedBlock(BlockContent blockContent, String modelPath, String modelPathSingle, Consumer<ConnectedModelProvider<?>> builder) {
        ConnectedModelProvider model = (ConnectedModelProvider)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelPath, "block/block")).texture("texture_single", modelPathSingle)).texture("texture_connected", modelPath)).customLoader(ConnectedModelProvider::new);
        builder.accept(model);
        this.simpleBlock(blockContent.block(), (ModelFile)model.end());
    }

    protected void buildConnectedBlock(BlockContent blockContent, Consumer<ConnectedModelProvider<?>> builder) {
        ConnectedModelProvider model = (ConnectedModelProvider)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockContent.modelPath(), "block/block")).texture("texture_single", this._modId + ":block/connected/" + blockContent.modelPath() + "_single")).texture("texture_connected", this._modId + ":block/connected/" + blockContent.modelPath())).customLoader(ConnectedModelProvider::new);
        builder.accept(model);
        this.simpleBlock(blockContent.block(), (ModelFile)model.end());
    }

    protected void buildSimpleBlock(BlockContent blockContent) {
        this.simpleBlock(blockContent.block());
    }

    protected void buildCloudBlock(EnumMap<?, BlockContent> wrappersMap) {
        this.buildCloudBlock(wrappersMap.values());
    }

    protected void buildCloudBlock(BlockContent blockContent) {
        BlockModelBuilder model = (BlockModelBuilder)this.cloudModel(blockContent.modelPath()).texture("tex", this._modId + ":block/" + blockContent.modelPath());
        this.simpleBlock(blockContent.block(), (ModelFile)model);
    }

    protected void buildCloudBlock(Iterable<BlockContent> wrappers) {
        BlockModelBuilder model = (BlockModelBuilder)this.cloudModel(wrappers.iterator().next().modelPath()).texture("tex", this._modId + ":block/" + wrappers.iterator().next().modelPath());
        wrappers.forEach(b -> this.simpleBlock(b.block(), (ModelFile)model));
    }

    protected BlockModelBuilder cloudModel(String modelPath) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelPath, "block/block")).texture("particle", CoreResources.CloudFX)).texture("cloud", CoreResources.CloudFX)).texture("tex", CoreResources.CloudFX)).renderType("cutout");
        if (model.getElementCount() == 0) {
            model.element().shade(false).from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).texture("#cloud").ao(false).emissive().cullface(Direction.DOWN).tintindex(0).end().face(Direction.UP).texture("#cloud").ao(false).emissive().cullface(Direction.UP).tintindex(0).end().face(Direction.NORTH).texture("#cloud").ao(false).emissive().cullface(Direction.NORTH).tintindex(0).end().face(Direction.SOUTH).texture("#cloud").ao(false).emissive().cullface(Direction.SOUTH).tintindex(0).end().face(Direction.WEST).texture("#cloud").ao(false).emissive().cullface(Direction.WEST).tintindex(0).end().face(Direction.EAST).texture("#cloud").ao(false).emissive().cullface(Direction.EAST).tintindex(0).end();
            model.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).texture("#tex").cullface(Direction.DOWN).end().face(Direction.UP).texture("#tex").cullface(Direction.UP).end().face(Direction.NORTH).texture("#tex").cullface(Direction.NORTH).end().face(Direction.SOUTH).texture("#tex").cullface(Direction.SOUTH).end().face(Direction.WEST).texture("#tex").cullface(Direction.WEST).end().face(Direction.EAST).texture("#tex").cullface(Direction.EAST).end();
        }
        return model;
    }

    protected BlockModelBuilder cloudModelTintable(String modelPath) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelPath, "block/block")).texture("particle", CoreResources.CloudFX)).texture("cloud", CoreResources.CloudFX)).texture("tex", CoreResources.CloudFX)).renderType("cutout");
        model.element().shade(false).from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).texture("#cloud").emissive().cullface(Direction.DOWN).tintindex(0).end().face(Direction.UP).texture("#cloud").emissive().cullface(Direction.UP).tintindex(0).end().face(Direction.NORTH).texture("#cloud").emissive().cullface(Direction.NORTH).tintindex(0).end().face(Direction.SOUTH).texture("#cloud").emissive().cullface(Direction.SOUTH).tintindex(0).end().face(Direction.WEST).texture("#cloud").emissive().cullface(Direction.WEST).tintindex(0).end().face(Direction.EAST).texture("#cloud").emissive().cullface(Direction.EAST).tintindex(0).end();
        model.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).texture("#tex").cullface(Direction.DOWN).tintindex(1).end().face(Direction.UP).texture("#tex").cullface(Direction.UP).tintindex(1).end().face(Direction.NORTH).texture("#tex").cullface(Direction.NORTH).tintindex(1).end().face(Direction.SOUTH).texture("#tex").cullface(Direction.SOUTH).tintindex(1).end().face(Direction.WEST).texture("#tex").cullface(Direction.WEST).tintindex(1).end().face(Direction.EAST).texture("#tex").cullface(Direction.EAST).tintindex(1).end();
        return model;
    }
}

