/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.data;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.block.ComparatorRedirector;
import de.melanx.utilitix.block.DimmableRedstoneLamp;
import de.melanx.utilitix.block.ModProperties;
import de.melanx.utilitix.data.state.RailState;
import de.melanx.utilitix.registration.ModBlocks;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.moddingx.libx.datagen.provider.BlockStateProviderBase;
import org.moddingx.libx.mod.ModX;

public class BlockStateProvider
extends BlockStateProviderBase {
    public static final ResourceLocation LINKED_REPEATER_PARENT = new ResourceLocation(UtilitiX.getInstance().modid, "block/linked_repeater_base");
    public static final ResourceLocation TEXTURE_REPEATER_OFF = new ResourceLocation("minecraft", "block/repeater");
    public static final ResourceLocation TEXTURE_REPEATER_ON = new ResourceLocation("minecraft", "block/repeater_on");
    public static final ResourceLocation TEXTURE_TORCH_OFF = new ResourceLocation("minecraft", "block/redstone_torch_off");
    public static final ResourceLocation TEXTURE_TORCH_ON = new ResourceLocation("minecraft", "block/redstone_torch");

    public BlockStateProvider(ModX mod, DataGenerator generator, ExistingFileHelper helper) {
        super(mod, generator, helper);
    }

    protected void setup() {
        this.manualState((Block)ModBlocks.weakRedstoneTorch);
        this.manualState((Block)ModBlocks.weakRedstoneTorch.wallTorch);
        this.manualModel((Block)ModBlocks.experienceCrystal);
        this.manualModel((Block)ModBlocks.advancedBrewery);
    }

    protected void defaultState(ResourceLocation id, Block block, Supplier<ModelFile> model) {
        if (block == ModBlocks.linkedRepeater) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(block);
            ModelBuilder modelOn = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(id.m_135815_() + "_on", LINKED_REPEATER_PARENT)).texture("repeater", TEXTURE_REPEATER_ON)).texture("torch", TEXTURE_TORCH_ON);
            ModelBuilder modelOff = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(id.m_135815_() + "_off", LINKED_REPEATER_PARENT)).texture("repeater", TEXTURE_REPEATER_OFF)).texture("torch", TEXTURE_TORCH_OFF);
            for (Direction dir : BlockStateProperties.f_61374_.m_6908_()) {
                Iterator iterator = BlockStateProperties.f_61426_.m_6908_().iterator();
                while (iterator.hasNext()) {
                    int power = (Integer)iterator.next();
                    builder.partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)dir).with((Property)BlockStateProperties.f_61426_, (Comparable)Integer.valueOf(power)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)(power > 0 ? modelOn : modelOff), 0, (int)dir.m_122435_(), false)});
                }
            }
        } else if (block instanceof BaseRailBlock) {
            BooleanProperty reverseProperty;
            Property shapeProperty = block.m_49965_().m_61092_().stream().filter(p -> RailShape.class.equals((Object)p.m_61709_())).findFirst().orElse(null);
            Object object = reverseProperty = block.m_49965_().m_61092_().contains(ModProperties.REVERSE) ? ModProperties.REVERSE : null;
            if (shapeProperty == null) {
                throw new IllegalStateException("Rail block without shape property.");
            }
            VariantBlockStateBuilder builder = this.getVariantBuilder(block);
            if (block.m_49965_().m_61092_().contains(ModProperties.RAIL_SIDE)) {
                RailState stateLeft = new RailState((Property<RailShape>)shapeProperty, (Property<Boolean>)reverseProperty, p -> p.with((Property)ModProperties.RAIL_SIDE, (Comparable)Boolean.valueOf(false)));
                RailState stateRight = new RailState((Property<RailShape>)shapeProperty, (Property<Boolean>)reverseProperty, p -> p.with((Property)ModProperties.RAIL_SIDE, (Comparable)Boolean.valueOf(true)));
                stateLeft.generate(this, builder, id, "left");
                stateRight.generate(this, builder, id, "right");
            } else if (block.m_49965_().m_61092_().contains(BlockStateProperties.f_61448_)) {
                RailState stateOff = new RailState((Property<RailShape>)shapeProperty, (Property<Boolean>)reverseProperty, p -> p.with((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)));
                RailState stateOn = new RailState((Property<RailShape>)shapeProperty, (Property<Boolean>)reverseProperty, p -> p.with((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)));
                stateOff.generate(this, builder, id);
                stateOn.generate(this, builder, id, "on");
            } else {
                RailState state = new RailState((Property<RailShape>)shapeProperty, (Property<Boolean>)reverseProperty);
                state.generate(this, builder, id);
            }
        } else if (block == ModBlocks.crudeFurnace) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(block);
            ModelBuilder modelOn = this.models().orientable(id.m_135815_() + "_on", this.modLoc("block/" + id.m_135815_() + "_side"), this.modLoc("block/" + id.m_135815_() + "_front_on"), this.modLoc("block/" + id.m_135815_() + "_top"));
            ModelBuilder modelOff = this.models().orientable(id.m_135815_(), this.modLoc("block/" + id.m_135815_() + "_side"), this.modLoc("block/" + id.m_135815_() + "_front"), this.modLoc("block/" + id.m_135815_() + "_top"));
            for (Direction dir : BlockStateProperties.f_61374_.m_6908_()) {
                Iterator iterator = AbstractFurnaceBlock.f_48684_.m_6908_().iterator();
                while (iterator.hasNext()) {
                    boolean value = (Boolean)iterator.next();
                    builder.partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)dir).with((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(value)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)(value ? modelOn : modelOff), 0, (int)dir.m_122424_().m_122435_(), false)});
                }
            }
        } else if (block == ModBlocks.stoneWall) {
            this.wallBlock((WallBlock)block, this.mcLoc("block/stone"));
        } else if (block == ModBlocks.dimmableRedstoneLamp) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(block);
            Iterator iterator = DimmableRedstoneLamp.SIGNAL.m_6908_().iterator();
            while (iterator.hasNext()) {
                ConfiguredModel signalModel;
                boolean isDefault;
                int signal = (Integer)iterator.next();
                boolean bl = isDefault = signal == 0 || signal == 15;
                if (isDefault) {
                    boolean on = signal == 15;
                    signalModel = new ConfiguredModel((ModelFile)this.models().cubeAll(id.m_135815_() + (String)(on ? "_" + signal : ""), this.mcLoc("block/redstone_lamp" + (on ? "_on" : ""))));
                } else {
                    signalModel = new ConfiguredModel((ModelFile)this.models().cubeAll(id.m_135815_() + "_" + signal, this.modLoc("block/dimmable_redstone_lamp_" + signal)));
                }
                builder.partialState().with((Property)DimmableRedstoneLamp.SIGNAL, (Comparable)Integer.valueOf(signal)).addModels(new ConfiguredModel[]{signalModel});
            }
        } else {
            super.defaultState(id, block, model);
        }
    }

    protected ModelFile defaultModel(ResourceLocation id, Block block) {
        if (block == ModBlocks.linkedRepeater || block instanceof BaseRailBlock || block == ModBlocks.crudeFurnace) {
            return null;
        }
        if (block instanceof ComparatorRedirector) {
            ResourceLocation top = new ResourceLocation(UtilitiX.getInstance().modid, "block/comparator_redirector_top");
            ResourceLocation bottom = new ResourceLocation(UtilitiX.getInstance().modid, "block/comparator_redirector_bottom");
            if (((ComparatorRedirector)block).direction == Direction.DOWN) {
                ResourceLocation tmp = top;
                top = bottom;
                bottom = tmp;
            }
            return this.models().cubeBottomTop(id.m_135815_(), new ResourceLocation(UtilitiX.getInstance().modid, "block/comparator_redirector_side"), top, bottom);
        }
        return super.defaultModel(id, block);
    }
}

