/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.fluid;

import cofh.lib.fluid.FluidCoFH;
import cofh.thermal.lib.common.ThermalItemGroups;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mrthomas20121.thermal_extra.init.ThermalExtraFluids;
import mrthomas20121.thermal_extra.init.ThermalExtraItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;

public class FluidThermalExtra
extends FluidCoFH {
    private final String key;
    private final RegistryObject<FluidType> type;

    public FluidThermalExtra(String key, final String stillTexture, final String flowTexture, int temp) {
        super(ThermalExtraFluids.FLUIDS, key);
        this.key = key;
        this.type = ThermalExtraFluids.FLUID_TYPES.register(key, () -> new FluidType(FluidType.Properties.create().lightLevel(12).density(4000).viscosity(2500).temperature(temp).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11770_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11769_)){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new ClientFluidTypeExtensions(new ResourceLocation(stillTexture), new ResourceLocation(flowTexture)));
            }
        });
        this.bucket = ThermalExtraItems.ITEMS.register(FluidThermalExtra.bucket((String)key), () -> new BucketItem((Supplier)this.stillFluid, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(ThermalItemGroups.THERMAL_ITEMS)));
    }

    public RegistryObject<Item> getBucket() {
        return this.bucket;
    }

    public RegistryObject<ForgeFlowingFluid> getStillFluid() {
        return this.stillFluid;
    }

    public RegistryObject<ForgeFlowingFluid> getFlowingFluid() {
        return this.flowingFluid;
    }

    protected ForgeFlowingFluid.Properties fluidProperties() {
        return new ForgeFlowingFluid.Properties(this.type(), (Supplier)this.stillFluid, (Supplier)this.flowingFluid).bucket((Supplier)this.bucket);
    }

    public TagKey<Fluid> getFluidTag() {
        return FluidTags.create((ResourceLocation)new ResourceLocation("forge", "molten_" + this.key));
    }

    protected Supplier<FluidType> type() {
        return this.type;
    }

    public static class ClientFluidTypeExtensions
    implements IClientFluidTypeExtensions {
        private final ResourceLocation still;
        private final ResourceLocation flow;

        public ClientFluidTypeExtensions(ResourceLocation still, ResourceLocation flow) {
            this.still = still;
            this.flow = flow;
        }

        public ResourceLocation getStillTexture() {
            return this.still;
        }

        public ResourceLocation getFlowingTexture() {
            return this.flow;
        }
    }
}

