/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Number;
import ca.teamdman.sfml.ast.ResourceQuantity;

public record Limit(ResourceQuantity quantity, ResourceQuantity retention) implements ASTNode
{
    public static final Limit MAX_QUANTITY_NO_RETENTION = new Limit(new ResourceQuantity(new Number(Long.MAX_VALUE), ResourceQuantity.IdExpansionBehaviour.NO_EXPAND), new ResourceQuantity(new Number(0L), ResourceQuantity.IdExpansionBehaviour.NO_EXPAND));
    public static final Limit MAX_QUANTITY_MAX_RETENTION = new Limit(new ResourceQuantity(new Number(Long.MAX_VALUE), ResourceQuantity.IdExpansionBehaviour.NO_EXPAND), new ResourceQuantity(new Number(Long.MAX_VALUE), ResourceQuantity.IdExpansionBehaviour.NO_EXPAND));
    public static final Limit UNSET = new Limit(ResourceQuantity.UNSET, ResourceQuantity.UNSET);

    public Limit withDefaults(Limit limit) {
        if (this.quantity() == ResourceQuantity.UNSET && this.retention() == ResourceQuantity.UNSET) {
            return limit;
        }
        if (this.quantity() == ResourceQuantity.UNSET) {
            return new Limit(limit.quantity(), this.retention());
        }
        if (this.retention() == ResourceQuantity.UNSET) {
            return new Limit(this.quantity(), limit.retention());
        }
        return this;
    }

    @Override
    public String toString() {
        return this.quantity + " RETAIN " + this.retention;
    }

    public String toStringCondensed(Limit defaults) {
        StringBuilder sb = new StringBuilder();
        if (!this.quantity.number().equals(defaults.quantity().number())) {
            sb.append(this.quantity);
        }
        if (!this.retention.number().equals(defaults.retention().number())) {
            if (!sb.isEmpty()) {
                sb.append(" ");
            }
            sb.append("RETAIN ").append(this.retention);
        }
        return sb.toString();
    }
}

