/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfml.ast.IfStatement;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Program;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ProgramContext {
    private final Program PROGRAM;
    private final ManagerBlockEntity MANAGER;
    private final CableNetwork NETWORK;
    private final List<InputStatement> INPUTS = new ArrayList<InputStatement>();
    private final Level LEVEL;
    private final ExecutionPolicy EXECUTION_POLICY;
    private final List<Branch> PATH_TAKEN = new ArrayList<Branch>();
    private final int EXPLORATION_BRANCH_INDEX;
    private final int REDSTONE_PULSES;

    public ProgramContext(Program program, ManagerBlockEntity manager, ExecutionPolicy executionPolicy) {
        this(program, manager, executionPolicy, 0);
    }

    public ProgramContext(Program program, ManagerBlockEntity manager, ExecutionPolicy executionPolicy, int branchIndex) {
        this.PROGRAM = program;
        this.MANAGER = manager;
        this.NETWORK = CableNetworkManager.getOrRegisterNetwork((BlockEntity)this.MANAGER).get();
        assert (this.MANAGER.m_58904_() != null);
        this.LEVEL = this.MANAGER.m_58904_();
        this.REDSTONE_PULSES = this.MANAGER.getUnprocessedRedstonePulseCount();
        this.EXECUTION_POLICY = executionPolicy;
        this.EXPLORATION_BRANCH_INDEX = branchIndex;
    }

    private ProgramContext(ProgramContext other) {
        this.PROGRAM = other.PROGRAM;
        this.MANAGER = other.MANAGER;
        this.NETWORK = other.NETWORK;
        this.LEVEL = other.LEVEL;
        this.REDSTONE_PULSES = other.REDSTONE_PULSES;
        this.EXECUTION_POLICY = other.EXECUTION_POLICY;
        this.EXPLORATION_BRANCH_INDEX = other.EXPLORATION_BRANCH_INDEX;
        this.INPUTS.addAll(other.INPUTS);
    }

    public ExecutionPolicy getExecutionPolicy() {
        return this.EXECUTION_POLICY;
    }

    public List<Branch> getExecutionPath() {
        return this.PATH_TAKEN;
    }

    public int getExplorationBranchIndex() {
        return this.EXPLORATION_BRANCH_INDEX;
    }

    public Program getProgram() {
        return this.PROGRAM;
    }

    public void pushPath(Branch branch) {
        this.PATH_TAKEN.add(branch);
    }

    public ProgramContext copy() {
        return new ProgramContext(this);
    }

    public int getRedstonePulses() {
        return this.REDSTONE_PULSES;
    }

    public ManagerBlockEntity getManager() {
        return this.MANAGER;
    }

    public void addInput(InputStatement input) {
        this.INPUTS.add(input);
    }

    public List<InputStatement> getInputs() {
        return this.INPUTS;
    }

    public CableNetwork getNetwork() {
        return this.NETWORK;
    }

    public static enum ExecutionPolicy {
        EXPLORE_BRANCHES,
        UNRESTRICTED;

    }

    public record Branch(IfStatement ifStatement, boolean wasTrue) {
    }
}

